/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.DOMParser;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sidekick.SideKickCompletion;
import sidekick.css.Utils;
import xml.Resolver;

public class CssSideKickCompletion
extends SideKickCompletion {
    public static final String SPECIAL_URL_PROP = "url...";
    public static String QUOTE;
    private static boolean choosingFile;
    private boolean selectedProperty;
    private static ArrayList<String> cssUnits;
    private static HashMap<String, ArrayList<String>> cssProperties;
    private static boolean initialized;
    private static final String COMPLETION_CONFIG_FILE = "jeditresource:/XML.jar!/xml/completion/css-complete.xml";
    private static Pattern HAS_PROP_COLON;
    private static boolean inited;

    public CssSideKickCompletion(List completions, String word, boolean selectedProperty) {
        super(jEdit.getActiveView(), word, completions);
        this.selectedProperty = selectedProperty;
        if (!inited) {
            CssSideKickCompletion.readConfig();
        }
    }

    public static void readConfig() {
        QUOTE = jEdit.getProperty((String)"options.csssidekick.quote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int index) {
        String selected = String.valueOf(this.get(index));
        JEditBuffer buffer = this.textArea.getBuffer();
        int caret = this.textArea.getCaretPosition();
        int moveCaret = 0;
        if (choosingFile) {
            return;
        }
        if (this.selectedProperty && jEdit.getBooleanProperty((String)"options.csssidekick.colon")) {
            String textAfter = buffer.getText(caret, buffer.getLength() - caret - 1);
            if (CssSideKickCompletion.canAddColon(textAfter)) {
                selected = selected + ":";
                if (jEdit.getBooleanProperty((String)"options.csssidekick.space-after-colon")) {
                    selected = selected + " ";
                }
            } else if (Pattern.compile("^\\s*:").matcher(textAfter).find()) {
                moveCaret = textAfter.indexOf(":") + 1;
            }
        } else if (selected.equals("url")) {
            selected = "url(" + QUOTE + QUOTE + ")";
            moveCaret = -2;
        } else if (selected.equals(SPECIAL_URL_PROP)) {
            choosingFile = true;
            selected = "url(" + QUOTE + Utils.chooseFileAndGetRelativePath() + QUOTE + ")";
            choosingFile = false;
        }
        Selection s = this.textArea.getSelectionAtOffset(caret);
        int start = s == null ? caret : s.getStart();
        int end = s == null ? caret : s.getEnd();
        try {
            buffer.beginCompoundEdit();
            buffer.remove(start - this.text.length(), this.text.length());
            buffer.insert(start - this.text.length(), selected);
        }
        finally {
            buffer.endCompoundEdit();
        }
        this.textArea.setCaretPosition(end + selected.length() + moveCaret - this.text.length());
    }

    public static HashMap getCssProperties() {
        return cssProperties;
    }

    public static ArrayList getCssUnits() {
        return cssUnits;
    }

    public static void setInitialized(boolean initialized) {
        CssSideKickCompletion.initialized = initialized;
    }

    public static boolean initialized() {
        return initialized;
    }

    public static void initialize() {
        CssSideKickCompletion.setInitialized(true);
        CssSideKickCompletion.readCompletionConfig();
    }

    private static boolean canAddColon(String textAfterCaret) {
        return !HAS_PROP_COLON.matcher(textAfterCaret).find();
    }

    private static void readCompletionConfig() {
        try {
            Log.log((int)1, CssSideKickCompletion.class, (Object)"Parsing configuration file: jeditresource:/XML.jar!/xml/completion/css-complete.xml");
            DOMParser parser = new DOMParser();
            parser.setEntityResolver((EntityResolver)Resolver.instance());
            InputSource source = Resolver.instance().resolveEntity(null, COMPLETION_CONFIG_FILE);
            parser.parse(source);
            Document doc = parser.getDocument();
            CssSideKickCompletion.initCssUnits(doc);
            CssSideKickCompletion.initCssProperties(doc);
            Log.log((int)1, CssSideKickCompletion.class, (Object)("Parsing done, found " + cssProperties.size() + " css properties and " + cssUnits.size() + " css units"));
        }
        catch (FileNotFoundException e) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"csssidekick.config-io-error", (Object[])new String[]{e.getMessage()});
        }
        catch (IOException e) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"csssidekick.config-io-error", (Object[])new String[]{e.getMessage()});
            Log.log((int)9, CssSideKickCompletion.class, (Object)e);
        }
        catch (SAXException e) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"csssidekick.config-xml-error", (Object[])new String[]{e.getMessage()});
            Log.log((int)9, CssSideKickCompletion.class, (Object)e);
        }
        catch (Exception e) {
            Log.log((int)9, CssSideKickCompletion.class, (Object)e);
        }
    }

    private static void initCssProperties(Document doc) {
        cssProperties = new HashMap();
        NodeList propertiesElements = doc.getElementsByTagName("properties");
        if (propertiesElements.getLength() != 1) {
            // empty if block
        }
        NodeList properties = ((Element)propertiesElements.item(0)).getElementsByTagName("property");
        int propCount = properties.getLength();
        for (int i = 0; i < propCount; ++i) {
            Element propEle = (Element)properties.item(i);
            String propName = propEle.getAttribute("name");
            NodeList values = propEle.getElementsByTagName("*");
            int valCount = values.getLength();
            ArrayList<String> valList = new ArrayList<String>();
            for (int j = 0; j < valCount; ++j) {
                Element ele = (Element)values.item(j);
                String name = ele.getAttribute("name");
                if (ele.getTagName().equals("include")) {
                    NodeList incValues = doc.getElementById(name).getElementsByTagName("value");
                    int incValCount = incValues.getLength();
                    for (int k = 0; k < incValCount; ++k) {
                        Element incValEle = (Element)incValues.item(k);
                        String incValText = incValEle.getFirstChild().getNodeValue();
                        if (incValText.equals("url")) {
                            valList.add(SPECIAL_URL_PROP);
                        }
                        valList.add(incValText);
                    }
                    continue;
                }
                String valText = ele.getFirstChild().getNodeValue();
                if (valText.equals("url")) {
                    valList.add(SPECIAL_URL_PROP);
                }
                valList.add(valText);
            }
            cssProperties.put(propName, valList);
        }
    }

    private static void initCssUnits(Document doc) {
        cssUnits = new ArrayList();
        NodeList unitsElements = doc.getElementsByTagName("units");
        NodeList units = ((Element)unitsElements.item(0)).getElementsByTagName("unit");
        int unitsCount = units.getLength();
        for (int i = 0; i < unitsCount; ++i) {
            Element unitEle = (Element)units.item(i);
            String unitText = unitEle.getFirstChild().getNodeValue();
            cssUnits.add(unitText);
        }
    }

    static {
        choosingFile = false;
        HAS_PROP_COLON = Pattern.compile("^[^;}]*:");
    }
}

