/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import sidekick.SideKickCompletion;
import sidekick.css.CssSideKickCompletion;

public class CompletionRequest {
    private List<String> completionList;
    private JEditBuffer buffer;
    private String textBeforeCaret;
    private String word;
    private static ArrayList emptyArrayList = new ArrayList(0);
    private static Pattern CURR_PROP = Pattern.compile("([\\w-]+):[^:]*$");
    private static Pattern GET_WORD = Pattern.compile("[^\\s:;{]*$");
    private static Pattern CAN_COMPLETE = Pattern.compile("[{;][^}]*([\\w-]|:\\s+)$");
    private static Pattern CAN_COMPLETE_VALUES = Pattern.compile(":[^;}]*$");
    private static Pattern CAN_COMPLETE_UNITS = Pattern.compile("^\\d+[a-z]+$");
    private static Pattern CAN_COMPLETE_ALL_UNITS = Pattern.compile("[;:{\\s.]\\d+$");
    private static Pattern UNIT_START = Pattern.compile("[a-z]+$");

    public CompletionRequest(EditPane editPane, int caret) {
        if (!CssSideKickCompletion.initialized()) {
            CssSideKickCompletion.initialize();
        }
        this.completionList = new ArrayList<String>();
        this.buffer = editPane.getBuffer();
        this.textBeforeCaret = this.buffer.getText(0, caret);
        this.word = this.getWord(this.textBeforeCaret);
    }

    public SideKickCompletion getSideKickCompletion() {
        boolean selectedProperty = false;
        if (!this.canComplete(this.textBeforeCaret)) {
            return null;
        }
        if (this.canAddAllUnits(this.textBeforeCaret)) {
            this.word = "";
            this.addMatchedToCompletionList(CssSideKickCompletion.getCssUnits());
        } else if (this.canCompleteUnit(this.word)) {
            this.word = this.getUnitStart(this.word);
            this.addMatchedToCompletionList(CssSideKickCompletion.getCssUnits(), this.word);
        } else if (this.canCompleteCssValues(this.textBeforeCaret)) {
            String currProperty = this.getCurrentCssProperty(this.textBeforeCaret);
            ArrayList values = this.getPropertyValues(currProperty);
            if (this.word.length() == 0) {
                this.addMatchedToCompletionList(values);
            } else {
                this.addMatchedToCompletionList(values, this.word);
            }
        } else {
            selectedProperty = true;
            this.addMatchedToCompletionList(this.findMatchedProperties(this.word));
        }
        if (this.completionList.size() > 0) {
            return new CssSideKickCompletion(this.completionList, this.word, selectedProperty);
        }
        return null;
    }

    private ArrayList findMatchedProperties(String startsWith) {
        ArrayList<String> found = new ArrayList<String>();
        for (String n : CssSideKickCompletion.getCssProperties().keySet()) {
            if (startsWith.equals(n) || !n.startsWith(startsWith)) continue;
            found.add(n);
        }
        Collections.sort(found);
        return found;
    }

    private void addMatchedToCompletionList(ArrayList cantidateCompletions, String startsWith) {
        for (String value : cantidateCompletions) {
            if (value.length() <= startsWith.length() || !value.startsWith(startsWith)) continue;
            this.completionList.add(value);
        }
    }

    private void addMatchedToCompletionList(ArrayList completions) {
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            this.completionList.add((String)it.next());
        }
    }

    private ArrayList getPropertyValues(String property) {
        if (CssSideKickCompletion.getCssProperties().containsKey(property)) {
            return (ArrayList)CssSideKickCompletion.getCssProperties().get(property);
        }
        return emptyArrayList;
    }

    private String getWord(String text) {
        Matcher wordM = GET_WORD.matcher(text);
        wordM.find();
        return wordM.group(0);
    }

    private String getUnitStart(String word) {
        Matcher m = UNIT_START.matcher(word);
        m.find();
        return m.group(0);
    }

    private String getCurrentCssProperty(String text) {
        Matcher m = CURR_PROP.matcher(text);
        m.find();
        return m.group(1);
    }

    private boolean canComplete(String text) {
        return CAN_COMPLETE.matcher(text).find();
    }

    private boolean canCompleteCssValues(String text) {
        return CAN_COMPLETE_VALUES.matcher(text).find();
    }

    private boolean canAddAllUnits(String text) {
        return CAN_COMPLETE_ALL_UNITS.matcher(text).find();
    }

    private boolean canCompleteUnit(String word) {
        return CAN_COMPLETE_UNITS.matcher(word).find();
    }
}

