/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sidekick.IAsset;
import sidekick.SideKickParsedData;
import sidekick.css.parser.CSSNode;
import sidekick.util.SideKickAsset;
import sidekick.util.SideKickElement;

public class CSSParsedData
extends SideKickParsedData {
    public CSSParsedData(String fileName) {
        super(fileName);
    }

    public TreePath getTreePathForPosition(int dot) {
        if (this.root.getChildCount() == 0) {
            return null;
        }
        Object userObject = this.root.getUserObject();
        if (userObject == null) {
            return null;
        }
        if (!(userObject instanceof SideKickAsset)) {
            return null;
        }
        SideKickAsset asset = (SideKickAsset)userObject;
        CSSNode css_node = (CSSNode)asset.getElement();
        DefaultMutableTreeNode node = this.root;
        if (this.nodeContains(css_node, dot)) {
            node = this.getLeafNode(this.root, dot);
        }
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        while (node != null) {
            nodeList.add(node);
            node = (DefaultMutableTreeNode)node.getParent();
        }
        Collections.reverse(nodeList);
        return new TreePath(nodeList.toArray());
    }

    private DefaultMutableTreeNode getLeafNode(DefaultMutableTreeNode node, int dot) {
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
            SideKickAsset asset = (SideKickAsset)child.getUserObject();
            CSSNode css_node = (CSSNode)asset.getElement();
            if (!this.nodeContains(css_node, dot)) continue;
            return this.getLeafNode(child, dot);
        }
        return node;
    }

    private boolean nodeContains(CSSNode node, int dot) {
        int start = node.getStartPosition().getOffset();
        int end = node.getEndPosition().getOffset();
        return start <= dot && dot <= end;
    }

    public IAsset getAssetAtOffset(int pos) {
        if (pos < 0) {
            return null;
        }
        Object userObject = this.root.getUserObject();
        if (userObject == null) {
            return null;
        }
        if (!(userObject instanceof SideKickAsset)) {
            return null;
        }
        SideKickAsset returnable = (SideKickAsset)userObject;
        CSSNode rootNode = (CSSNode)returnable.getElement();
        if (!rootNode.hasChildren()) {
            return returnable;
        }
        for (CSSNode child : rootNode.getChildren()) {
            if (pos < child.getStartPosition().getOffset() || pos > child.getEndPosition().getOffset()) continue;
            CSSNode node = this.getCSSNodeAtOffset(child, pos);
            SideKickAsset asset = new SideKickAsset((SideKickElement)node);
            asset.setStart(node.getStartPosition());
            asset.setEnd(node.getEndPosition());
            return asset;
        }
        return returnable;
    }

    private CSSNode getCSSNodeAtOffset(CSSNode tn, int pos) {
        for (CSSNode child : tn.getChildren()) {
            try {
                if (pos < child.getStartPosition().getOffset() || pos > child.getEndPosition().getOffset()) continue;
                return this.getCSSNodeAtOffset(child, pos);
            }
            catch (NullPointerException e) {
            }
        }
        return tn;
    }
}

