/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css;

import errorlist.DefaultErrorSource;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import sidekick.SideKickCompletion;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickUpdate;
import sidekick.css.CSSModeToolBar;
import sidekick.css.CSSParsedData;
import sidekick.css.CompletionRequest;
import sidekick.css.parser.CSS3Parser;
import sidekick.css.parser.CSSNode;
import sidekick.util.ElementUtil;
import sidekick.util.ParseError;
import sidekick.util.Range;

public class CSS2SideKickParser
extends SideKickParser
implements EBComponent {
    private View currentView = null;
    public static boolean showAll = true;
    private int lineOffset = 0;
    private int columnOffset = 0;
    private Comparator<CSSNode> nodeSorter = new Comparator<CSSNode>(){

        @Override
        public int compare(CSSNode tna, CSSNode tnb) {
            int sortBy = jEdit.getIntegerProperty((String)"sidekick.css.sortBy", (int)1);
            switch (sortBy) {
                case 0: {
                    Integer my_line = new Integer(tna.getStartLocation().line);
                    Integer other_line = new Integer(tnb.getStartLocation().line);
                    return my_line.compareTo(other_line);
                }
            }
            return tna.getName().toLowerCase().compareTo(tnb.getName().toLowerCase());
        }
    };

    public CSS2SideKickParser() {
        super("css");
        EditBus.addToBus((EBComponent)this);
    }

    public void setLineOffset(int offset) {
        if (offset > 0) {
            this.lineOffset = offset;
        }
    }

    public void setColumnOffset(int offset) {
        if (offset > 0) {
            this.columnOffset = offset;
        }
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            if (this.currentView != null) {
                this.currentView = jEdit.getActiveView();
            }
            EditBus.send((EBMessage)new SideKickUpdate(this.currentView));
        }
    }

    public void parse() {
        if (this.currentView != null) {
            this.parse(this.currentView.getBuffer(), null);
        }
    }

    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        this.setLineOffset(0);
        return this.parse(buffer, buffer.getText(0, buffer.getLength()), errorSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buffer, String text, DefaultErrorSource errorSource) {
        String filename = buffer.getPath();
        CSSParsedData parsedData = new CSSParsedData(buffer.getName());
        DefaultMutableTreeNode root = parsedData.root;
        StringReader reader = new StringReader(text);
        try {
            CSS3Parser parser = new CSS3Parser(reader, this.lineOffset, this.columnOffset);
            parser.setTabSize(buffer.getTabSize());
            parser.setProprietaryAsError(jEdit.getBooleanProperty((String)"options.csssidekick.showProprietaryAsError"));
            CSSNode ss = parser.styleSheet();
            root.setUserObject(ss);
            this.addTreeNodes(root, ss);
            ElementUtil.convert((Buffer)buffer, (DefaultMutableTreeNode)root);
            if (!buffer.isDirty() && errorSource != null) {
                List<ParseError> parseErrors = parser.getParseErrors();
                for (ParseError pe : parseErrors) {
                    String message = pe.message;
                    Range range = pe.range;
                    if (range.endLine != range.startLine) {
                        range.endColumn = range.startColumn;
                    }
                    errorSource.addError(0, filename, range.startLine, range.startColumn, range.endColumn, message);
                }
                List<ParseError> parseWarnings = parser.getParseWarnings();
                for (ParseError pe : parseWarnings) {
                    String message = pe.message;
                    Range range = pe.range;
                    if (range.endLine != range.startLine) {
                        range.endColumn = range.startColumn;
                    }
                    errorSource.addError(1, filename, range.startLine, range.startColumn, range.endColumn, message);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            reader.close();
        }
        return parsedData;
    }

    private void addTreeNodes(DefaultMutableTreeNode root, CSSNode ss) {
        if (ss.hasChildren()) {
            List<CSSNode> children = ss.getChildren();
            Collections.sort(children, this.nodeSorter);
            for (CSSNode cssChild : children) {
                if (cssChild == null) continue;
                DefaultMutableTreeNode dmtNode = new DefaultMutableTreeNode(cssChild);
                root.add(dmtNode);
                this.addTreeNodeChildren(dmtNode, cssChild);
            }
        }
    }

    private void addTreeNodeChildren(DefaultMutableTreeNode dmtNode, CSSNode cssNode) {
        if (cssNode.hasChildren()) {
            List<CSSNode> children = cssNode.getChildren();
            Collections.sort(children, this.nodeSorter);
            for (CSSNode cssChild : children) {
                if (cssChild == null) continue;
                DefaultMutableTreeNode dmtChild = new DefaultMutableTreeNode(cssChild);
                dmtNode.add(dmtChild);
                this.addTreeNodeChildren(dmtChild, cssChild);
            }
        }
    }

    public boolean supportsCompletion() {
        return true;
    }

    public boolean canCompleteAnywhere() {
        return true;
    }

    public SideKickCompletion complete(EditPane editPane, int caret) {
        CompletionRequest cr = new CompletionRequest(editPane, caret);
        return cr.getSideKickCompletion();
    }

    public JPanel getPanel() {
        return new CSSModeToolBar(this);
    }
}

