/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ftp.FtpAddress;
import junit.framework.TestCase;

public class FtpAddressTest
extends TestCase {
    public void testSFtpFull() {
        FtpAddress addr = new FtpAddress("sftp://user@hell:pwd@voituk.kiev.ua:22/home/www@hello.com/111.html");
        FtpAddressTest.assertEquals((String)"sftp", (String)addr.getScheme());
        FtpAddressTest.assertEquals((String)"voituk.kiev.ua", (String)addr.getHost());
        FtpAddressTest.assertEquals((int)22, (int)addr.getPort());
        FtpAddressTest.assertEquals((String)"/home/www@hello.com/111.html", (String)addr.getPath());
        FtpAddressTest.assertEquals((String)"user@hell", (String)addr.getUser());
        FtpAddressTest.assertEquals((String)"pwd", (String)addr.getPassword());
    }

    public void testFtpFullWithoutPort() {
        FtpAddress addr = new FtpAddress("ftp://user@domain@voituk.kiev.ua/home/www/ ");
        FtpAddressTest.assertEquals((String)"ftp", (String)addr.getScheme());
        FtpAddressTest.assertEquals((String)"voituk.kiev.ua", (String)addr.getHost());
        FtpAddressTest.assertEquals((int)21, (int)addr.getPort());
        FtpAddressTest.assertEquals((String)"/home/www/", (String)addr.getPath());
        FtpAddressTest.assertEquals((String)"user@domain", (String)addr.getUser());
        FtpAddressTest.assertEquals(null, (String)addr.getPassword());
    }

    public void testFtpShort() {
        FtpAddress addr = new FtpAddress("ftp://voituk.kiev.ua");
        FtpAddressTest.assertEquals((String)"ftp", (String)addr.getScheme());
        FtpAddressTest.assertEquals((String)"voituk.kiev.ua", (String)addr.getHost());
        FtpAddressTest.assertEquals((int)21, (int)addr.getPort());
        FtpAddressTest.assertEquals((String)"", (String)addr.getPath());
        FtpAddressTest.assertEquals(null, (String)addr.getUser());
        FtpAddressTest.assertEquals(null, (String)addr.getPassword());
    }

    public void testFtpShortPort() {
        FtpAddress addr = new FtpAddress("ftp://voituk.kiev.ua:2121/");
        FtpAddressTest.assertEquals((String)"ftp", (String)addr.getScheme());
        FtpAddressTest.assertEquals((String)"voituk.kiev.ua", (String)addr.getHost());
        FtpAddressTest.assertEquals((int)2121, (int)addr.getPort());
        FtpAddressTest.assertEquals((String)"/", (String)addr.getPath());
        FtpAddressTest.assertEquals(null, (String)addr.getUser());
        FtpAddressTest.assertEquals(null, (String)addr.getPassword());
    }

    public void testBugRequest_2768807() {
        FtpAddress addr = new FtpAddress("ftp://user.name@emaildomain.com@example.com:21/~/");
        FtpAddressTest.assertEquals((String)"user.name@emaildomain.com", (String)addr.getUser());
        FtpAddressTest.assertEquals((String)"example.com", (String)addr.getHost());
    }
}

