/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import ftp.Connection;
import ftp.ConnectionInfo;
import ftp.ConnectionManager;
import ftp.FtpVFS;
import ftp.PasswordDialog;
import ftp.SftpLogger;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SFtpConnection
extends Connection
implements UserInfo,
UIKeyboardInteractive {
    private ChannelSftp sftp;
    private Session session;
    private int keyAttempts = 0;
    private String passphrase = null;

    public SFtpConnection(ConnectionInfo info) throws IOException {
        super(info);
        try {
            if (ConnectionManager.client == null) {
                ConnectionManager.client = new JSch();
            }
            JSch.setLogger((Logger)new SftpLogger());
            String settingsDirectory = jEdit.getSettingsDirectory();
            if (settingsDirectory != null) {
                String cacheDir = MiscUtilities.constructPath((String)settingsDirectory, (String)"cache");
                String known_hosts = MiscUtilities.constructPath((String)cacheDir, (String)"known_hosts");
                try {
                    new File(known_hosts).createNewFile();
                    ConnectionManager.client.setKnownHosts(known_hosts);
                }
                catch (IOException e) {
                    Log.log((int)7, ConnectionManager.class, (Object)("Unable to create password file:" + known_hosts));
                }
            }
            ProxySOCKS5 proxy = null;
            if (jEdit.getBooleanProperty((String)"vfs.ftp.useProxy")) {
                if (jEdit.getBooleanProperty((String)"firewall.socks.enabled", (boolean)false)) {
                    proxy = new ProxySOCKS5(jEdit.getProperty((String)"firewall.socks.host"), jEdit.getIntegerProperty((String)"firewall.socks.port", (int)3128));
                } else if (jEdit.getBooleanProperty((String)"firewall.enabled", (boolean)false)) {
                    ProxyHTTP httpProxy = new ProxyHTTP(jEdit.getProperty((String)"firewall.host"), jEdit.getIntegerProperty((String)"firewall.port", (int)3128));
                    if (!jEdit.getProperty((String)"firewall.user", (String)"").equals("")) {
                        httpProxy.setUserPasswd(jEdit.getProperty((String)"firewall.user"), jEdit.getProperty((String)"firewall.password"));
                    }
                    proxy = httpProxy;
                }
            }
            this.session = ConnectionManager.client.getSession(info.user, info.host, info.port);
            if (proxy != null) {
                this.session.setProxy((Proxy)proxy);
            }
            Log.log((int)1, (Object)this, (Object)("info.privateKey=" + info.privateKey));
            if (info.privateKey != null && info.privateKey.length() > 0) {
                Log.log((int)1, (Object)this, (Object)"Attempting public key authentication");
                Log.log((int)1, (Object)this, (Object)("Using key: " + info.privateKey));
                ConnectionManager.client.addIdentity(info.privateKey);
            }
            this.keyAttempts = 0;
            this.session.setUserInfo((UserInfo)this);
            if (jEdit.getBooleanProperty((String)"vfs.sftp.compression")) {
                this.session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                this.session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                this.session.setConfig("compression_level", "9");
            }
            this.session.setConfig("MaxAuthTries", "1");
            this.session.connect(ConnectionManager.connectionTimeout);
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.sftp = (ChannelSftp)channel;
            this.home = this.sftp.getHome();
            this.keyAttempts = 0;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    FtpVFS.FtpDirectoryEntry[] listDirectory(String path) throws IOException {
        ArrayList<FtpVFS.FtpDirectoryEntry> listing = new ArrayList<FtpVFS.FtpDirectoryEntry>();
        int count = 0;
        try {
            Vector vv = this.sftp.ls(path);
            if (vv != null) {
                for (int ii = 0; ii < vv.size(); ++ii) {
                    Object obj = vv.elementAt(ii);
                    if (!(obj instanceof ChannelSftp.LsEntry)) continue;
                    ++count;
                    ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)obj;
                    listing.add(this.createDirectoryEntry(entry.getFilename(), entry.getAttrs()));
                }
            }
        }
        catch (SftpException e) {
            return null;
        }
        FtpVFS.FtpDirectoryEntry[] result = listing.toArray(new FtpVFS.FtpDirectoryEntry[listing.size()]);
        return result;
    }

    @Override
    FtpVFS.FtpDirectoryEntry getDirectoryEntry(String path) throws IOException {
        FtpVFS.FtpDirectoryEntry returnValue = null;
        try {
            SftpATTRS attrs = this.sftp.stat(path);
            String name = MiscUtilities.getFileName((String)path);
            returnValue = this.createDirectoryEntry(name, attrs);
            returnValue.setPath(path);
            returnValue.setDeletePath(path);
        }
        catch (SftpException sftpException) {
            // empty catch block
        }
        return returnValue;
    }

    @Override
    boolean removeFile(String path) throws IOException {
        try {
            this.sftp.rm(path);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    boolean removeDirectory(String path) throws IOException {
        try {
            this.sftp.rmdir(path);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    boolean rename(String from, String to) throws IOException {
        try {
            this.sftp.rename(from, to);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    boolean makeDirectory(String path) throws IOException {
        try {
            this.sftp.mkdir(path);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    InputStream retrieve(String path) throws IOException {
        try {
            return this.sftp.get(path);
        }
        catch (SftpException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    OutputStream store(String path) throws IOException {
        OutputStream returnValue;
        try {
            returnValue = this.sftp.put(path);
        }
        catch (SftpException e) {
            throw new IOException(e.toString());
        }
        return returnValue;
    }

    @Override
    void chmod(String path, int permissions) throws IOException {
        try {
            this.sftp.chmod(permissions, path);
        }
        catch (SftpException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    boolean checkIfOpen() throws IOException {
        return this.sftp.isConnected();
    }

    @Override
    public String resolveSymlink(String path, String[] name) throws IOException {
        return path;
    }

    @Override
    void logout() throws IOException {
        this.sftp.disconnect();
        this.session.disconnect();
    }

    private FtpVFS.FtpDirectoryEntry createDirectoryEntry(String name, SftpATTRS attrs) {
        long length = attrs.getSize();
        int permissions = attrs.getPermissions();
        int type = attrs.isDir() ? 1 : (attrs.isLink() ? 10 : 0);
        FtpVFS.FtpDirectoryEntry entry = new FtpVFS.FtpDirectoryEntry(name, null, null, type, length, name.startsWith("."), permissions &= 0x1FF, null);
        int mtime = attrs.getMTime();
        if (mtime != 0) {
            Date date = new Date((long)mtime * 1000L);
            String modTime = FileVFS.LocalFile.DATE_FORMAT.format(date);
            entry.setModifiedDate(modTime);
        }
        entry.setWriteable((permissions & 0x80) != 0);
        entry.setReadable((permissions & 0x100) != 0);
        return entry;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.info.password;
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public boolean promptPassphrase(String message) {
        Log.log((int)1, (Object)this, (Object)message);
        this.passphrase = ConnectionManager.getPassphrase(this.info.privateKey);
        if (this.passphrase == null || this.keyAttempts != 0) {
            PasswordDialog pd = new PasswordDialog((JFrame)jEdit.getActiveView(), jEdit.getProperty((String)"login.privatekeypassword"), message);
            if (!pd.isOK()) {
                return false;
            }
            this.passphrase = new String(pd.getPassword());
            ConnectionManager.setPassphrase(this.info.privateKey, this.passphrase);
        }
        ++this.keyAttempts;
        return true;
    }

    public boolean promptYesNo(final String message) {
        final int[] ret = new int[1];
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{"yes", "no"};
                    ret[0] = JOptionPane.showOptionDialog((Component)jEdit.getActiveView(), message, "Warning", -1, 2, null, options, options[0]);
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException e) {
            Log.log((int)9, (Object)this, (Object)e);
        }
        catch (InvocationTargetException e) {
            Log.log((int)9, (Object)this, (Object)e);
        }
        return ret[0] == 0;
    }

    public void showMessage(String message) {
        Log.log((int)9, (Object)this, (Object)message);
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length != 1 || echo[0]) {
            return null;
        }
        String[] response = new String[]{this.getPassword()};
        return response;
    }
}

