/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import ftp.ConnectionManager;
import ftp.FtpVFS;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;

public class LoginDialog
extends EnhancedDialog
implements ActionListener {
    private HistoryTextField hostField;
    private HistoryTextField userField;
    private JPasswordField passwordField;
    private HistoryTextField privateKeyField;
    private JButton privateKeySelect;
    private JCheckBox passive;
    private JCheckBox storePassword;
    private JCheckBox useProxy;
    private String host;
    private String user;
    private String password;
    private String privateKeyFilename;
    private boolean isOK;
    private boolean secure;
    private JButton ok;
    private JButton cancel;

    public LoginDialog(Component comp, boolean _secure, String host, String user, String password) {
        super(JOptionPane.getFrameForComponent(comp), jEdit.getProperty((String)(_secure ? "login.title-sftp" : "login.title-ftp")), true);
        this.secure = _secure;
        JPanel content = new JPanel((LayoutManager)new VariableGridLayout(2, 1, 6, 6));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        content.add(this.createFieldPanel(this.secure, host, user, password));
        this.useProxy = new JCheckBox(jEdit.getProperty((String)(this.secure ? "login.useProxy" : "login.useProxyHttp")), jEdit.getBooleanProperty((String)"vfs.ftp.useProxy", (boolean)false));
        if (!this.secure) {
            this.passive = new JCheckBox(jEdit.getProperty((String)"login.passive"), jEdit.getBooleanProperty((String)"vfs.ftp.passive"));
            this.passive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LoginDialog.this.useProxy.setEnabled(LoginDialog.this.passive.isSelected());
                }
            });
            this.useProxy.setEnabled(this.passive.isSelected());
            content.add(this.passive);
        }
        content.add(this.useProxy);
        this.storePassword = new JCheckBox(jEdit.getProperty((String)"options.ftp.savePasswords"), jEdit.getBooleanProperty((String)"vfs.ftp.storePassword"));
        content.add(this.storePassword);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add(buttons);
        Object focus = host == null ? this.hostField : (user == null ? this.userField : this.passwordField);
        GUIUtilities.requestFocus((Window)((Object)this), (Component)focus);
        this.pack();
        this.setLocationRelativeTo(comp);
        this.setModal(true);
    }

    public void ok() {
        this.hostField.addCurrentToHistory();
        this.userField.addCurrentToHistory();
        if (this.privateKeyField != null) {
            this.privateKeyField.addCurrentToHistory();
        }
        if (this.passive != null) {
            jEdit.setBooleanProperty((String)"vfs.ftp.passive", (boolean)this.passive.isSelected());
        }
        if (this.storePassword != null) {
            jEdit.setBooleanProperty((String)"vfs.ftp.storePassword", (boolean)this.storePassword.isSelected());
        }
        if (this.useProxy != null) {
            jEdit.setBooleanProperty((String)"vfs.ftp.useProxy", (boolean)this.useProxy.isSelected());
        }
        if (this.hostField.hasFocus() && this.userField.getText().length() == 0) {
            this.userField.requestFocus();
        } else if (this.userField.hasFocus() && this.passwordField.getPassword().length == 0) {
            this.passwordField.requestFocus();
        } else {
            if (this.passwordField.getPassword().length == 0 && this.privateKeyField != null && this.privateKeyField.getText().length() == 0) {
                return;
            }
            this.host = this.hostField.getText();
            this.user = this.userField.getText();
            if (this.privateKeyField != null && this.privateKeyField.getText().length() > 0) {
                this.privateKeyFilename = this.privateKeyField.getText();
            }
            if (this.host.length() == 0 || this.user.length() == 0) {
                this.getToolkit().beep();
                return;
            }
            this.password = new String(this.passwordField.getPassword());
            this.isOK = true;
            this.dispose();
        }
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKeyFilename() {
        return this.privateKeyFilename;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.hostField) {
            this.userField.requestFocus();
        } else if (source == this.userField) {
            this.passwordField.requestFocus();
        } else if (source == this.passwordField) {
            this.ok();
        } else if (source == this.privateKeyField) {
            this.ok();
        }
    }

    private JPanel createFieldPanel(boolean secure, String host, String user, String password) {
        JPanel panel = new JPanel((LayoutManager)new VariableGridLayout(2, 2, 6, 6));
        JLabel label = new JLabel(jEdit.getProperty((String)"login.host"), 4);
        panel.add(label);
        this.hostField = new HistoryTextField(secure ? "sftp.host" : "ftp.host");
        this.hostField.setText(host);
        this.hostField.setColumns(20);
        if (host != null) {
            this.hostField.setEnabled(false);
        }
        this.hostField.getDocument().addDocumentListener(new FieldCompletionListener());
        this.hostField.addActionListener((ActionListener)this);
        panel.add((Component)this.hostField);
        label = new JLabel(jEdit.getProperty((String)"login.user"), 4);
        panel.add(label);
        this.userField = new HistoryTextField("ftp.user");
        this.userField.setText(user);
        this.userField.setColumns(20);
        this.userField.getDocument().addDocumentListener(new FieldCompletionListener());
        this.userField.addActionListener((ActionListener)this);
        panel.add((Component)this.userField);
        label = new JLabel(jEdit.getProperty((String)"login.password"), 4);
        panel.add(label);
        this.passwordField = new JPasswordField(password, 20);
        this.passwordField.addActionListener(this);
        panel.add(this.passwordField);
        if (secure) {
            Box privateKeyBox = Box.createHorizontalBox();
            this.privateKeyField = new HistoryTextField("sftp.privateKey");
            this.privateKeyField.addActionListener((ActionListener)this);
            label = new JLabel(jEdit.getProperty((String)"login.privateKey"), 4);
            panel.add(label);
            privateKeyBox.add((Component)this.privateKeyField);
            this.privateKeySelect = new JButton("...");
            this.privateKeySelect.setMargin(new Insets(0, 0, 0, 0));
            this.privateKeySelect.addActionListener(new PrivateKeySelectActionListener((Component)((Object)this)));
            privateKeyBox.add(this.privateKeySelect);
            panel.add(privateKeyBox);
        }
        this.checkKey();
        return panel;
    }

    public void checkKey() {
        String host = this.hostField.getText();
        String user = this.userField.getText();
        if (host.indexOf(":") == -1) {
            host = host + ":" + FtpVFS.getDefaultPort(this.secure);
        }
        String key = this.secure ? ConnectionManager.getStoredFtpKey(host, user) : null;
        String pass = ConnectionManager.getPassword(host + "." + user);
        if (this.secure) {
            if (key != null) {
                this.privateKeyField.setText(key);
            } else {
                this.privateKeyField.setText("");
            }
        }
        if (pass != null) {
            this.passwordField.setText(pass);
        }
    }

    class FieldCompletionListener
    implements DocumentListener {
        FieldCompletionListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LoginDialog.this.checkKey();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LoginDialog.this.checkKey();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LoginDialog.this.checkKey();
        }
    }

    class PrivateKeySelectActionListener
    implements ActionListener {
        private Component parent;

        public PrivateKeySelectActionListener(Component c) {
            this.parent = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(jEdit.getProperty((String)"login.selectprivatekey"));
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(this.parent);
            if (returnVal == 0) {
                try {
                    LoginDialog.this.privateKeyField.setText(chooser.getSelectedFile().getCanonicalPath());
                }
                catch (IOException err) {
                    // empty catch block
                }
            }
        }
    }
}

