/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import ftp.Connection;
import ftp.ConnectionInfo;
import ftp.ConnectionManager;
import ftp.DirectoryCache;
import ftp.FtpAddress;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.LocalFileSaveTask;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class FtpVFS
extends VFS {
    public static final String FTP_PROTOCOL = "ftp";
    public static final String SFTP_PROTOCOL = "sftp";
    public static final String EA_OWNER_USER = "user";
    public static final String EA_OWNER_GROUP = "group";
    public static final String PERMISSIONS_PROPERTY = "FileVFS__perms";
    public static final String MD5SUM_PROPERTY = "FtpVFS__MD5";
    private boolean secure;

    public FtpVFS(boolean secure) {
        super(FtpVFS.getProtocol(secure), 63, FtpVFS.getExtendedAttributes(secure));
        this.secure = secure;
    }

    public static String getProtocol(boolean secure) {
        return secure ? SFTP_PROTOCOL : FTP_PROTOCOL;
    }

    public static String[] getExtendedAttributes(boolean secure) {
        String[] stringArray;
        if (secure) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "size";
            stringArray2[1] = "modified";
            stringArray = stringArray2;
            stringArray2[2] = "type";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "size";
            stringArray3[1] = "status";
            stringArray = stringArray3;
            stringArray3[2] = "type";
        }
        return stringArray;
    }

    public static int getDefaultPort(boolean secure) {
        return secure ? 22 : 21;
    }

    public String showBrowseDialog(Object[] session, Component comp) {
        FtpSession newSession = (FtpSession)this.createVFSSession(null, comp);
        if (newSession == null) {
            return null;
        }
        if (session != null) {
            session[0] = newSession;
        }
        return FtpVFS.getProtocol(this.secure) + "://" + newSession.info.getUser() + "@" + newSession.info.getHost() + ":" + newSession.info.getPort() + "/~/";
    }

    public String getFileName(String path) {
        FtpAddress address = new FtpAddress(path);
        if (address.getPath().equals("/") || address.getPath().length() == 1) {
            address.setPath("");
            return address.toString();
        }
        return super.getFileName(address.getPath());
    }

    public String getParentOfPath(String path) {
        FtpAddress address = new FtpAddress(path);
        address.setPath(super.getParentOfPath(address.getPath()));
        return address.toString();
    }

    public String constructPath(String parent, String path) {
        if (path.startsWith("~")) {
            path = "/" + path;
        }
        if (path.startsWith("/")) {
            FtpAddress address = new FtpAddress(parent);
            address.setPath(path);
            return address.toString();
        }
        if (parent.endsWith("/")) {
            return parent + path;
        }
        return parent + '/' + path;
    }

    public void reloadDirectory(String path) {
        DirectoryCache.clearCachedDirectory(path);
    }

    public Object createVFSSession(String path, Component comp) {
        try {
            Log.log((int)1, (Object)((Object)this), (Object)("FtpVFS.createVFSSession(" + path + ", " + comp + ")"));
            ConnectionInfo info = ConnectionManager.getConnectionInfo(comp, path == null ? null : new FtpAddress(path), this.secure);
            if (info == null) {
                return null;
            }
            return new FtpSession(info);
        }
        catch (IllegalArgumentException ia) {
            return null;
        }
    }

    public void _endVFSSession(Object _session, Component comp) {
        FtpSession session = (FtpSession)_session;
        ConnectionManager.releaseConnection(session.connection);
    }

    public String _canonPath(Object _session, String path, Component comp) throws IOException {
        FtpAddress address = new FtpAddress(path);
        if (address.getPath().startsWith("/~")) {
            Connection session = FtpVFS.getConnection(_session);
            if (session.home != null) {
                if (session.home.endsWith("/")) {
                    address.setPath(session.home + address.getPath().substring(2));
                } else {
                    address.setPath(session.home + '/' + address.getPath().substring(2));
                }
                if (address.getPath().endsWith("/") && address.getPath().length() != 1) {
                    address.setPath(address.getPath().substring(0, address.getPath().length() - 1));
                }
            }
        }
        return address.toString();
    }

    public VFSFile[] _listFiles(Object _session, String url, Component comp) throws IOException {
        FtpAddress address;
        VFSFile[] directory = DirectoryCache.getCachedDirectory(url);
        if (directory != null) {
            return directory;
        }
        Connection session = FtpVFS.getConnection(_session);
        directory = session.listDirectory((address = new FtpAddress(url)).getPath());
        if (directory != null) {
            for (int i = 0; i < directory.length; ++i) {
                FtpDirectoryEntry entry = (FtpDirectoryEntry)directory[i];
                if (entry.getType() == 10) {
                    this.resolveSymlink(_session, url, entry);
                    continue;
                }
                entry.setPath(this.constructPath(url, entry.getName()));
                entry.setDeletePath(entry.getPath());
            }
            DirectoryCache.setCachedDirectory(url, directory);
        }
        return directory;
    }

    public VFSFile _getFile(Object _session, String path, Component comp) throws IOException {
        FtpAddress address;
        Connection session = FtpVFS.getConnection(_session);
        FtpDirectoryEntry dirEntry = session.getDirectoryEntry((address = new FtpAddress(path)).getPath());
        if (dirEntry != null) {
            Buffer buffer;
            if (dirEntry.getType() == 10) {
                String parentPath = MiscUtilities.getParentOfPath((String)path);
                this.resolveSymlink(_session, parentPath, dirEntry);
            }
            if (address.toString().equals(path) && (buffer = jEdit.getBuffer((String)path)) != null) {
                Log.log((int)1, (Object)((Object)this), (Object)(path + " has permissions 0" + Integer.toString(dirEntry.permissions, 8)));
                buffer.setIntegerProperty(PERMISSIONS_PROPERTY, dirEntry.permissions);
            }
        }
        return dirEntry;
    }

    public boolean _delete(Object _session, String url, Component comp) throws IOException {
        Connection session = FtpVFS.getConnection(_session);
        FtpAddress address = new FtpAddress(url);
        VFSFile directoryEntry = this._getFile(_session, url, comp);
        if (directoryEntry == null) {
            return false;
        }
        boolean returnValue = directoryEntry.getType() == 0 ? session.removeFile(address.getPath()) : session.removeDirectory(address.getPath());
        DirectoryCache.clearCachedDirectory(this.getParentOfPath(url));
        VFSManager.sendVFSUpdate((VFS)this, (String)url, (boolean)true);
        return returnValue;
    }

    public boolean _rename(Object _session, String from, String to, Component comp) throws IOException {
        Connection session = FtpVFS.getConnection(_session);
        FtpAddress address = new FtpAddress(from);
        String toPath = new FtpAddress(to).getPath();
        VFSFile directoryEntry = this._getFile(_session, from, comp);
        if (directoryEntry == null) {
            return false;
        }
        directoryEntry = this._getFile(_session, to, comp);
        if (directoryEntry != null && directoryEntry.getType() == 0 && !address.getPath().equalsIgnoreCase(toPath)) {
            session.removeFile(toPath);
        }
        boolean returnValue = session.rename(address.getPath(), toPath);
        DirectoryCache.clearCachedDirectory(this.getParentOfPath(from));
        DirectoryCache.clearCachedDirectory(this.getParentOfPath(to));
        VFSManager.sendVFSUpdate((VFS)this, (String)from, (boolean)true);
        VFSManager.sendVFSUpdate((VFS)this, (String)to, (boolean)true);
        return returnValue;
    }

    public boolean _mkdir(Object _session, String directory, Component comp) throws IOException {
        Connection session = FtpVFS.getConnection(_session);
        FtpAddress address = new FtpAddress(directory);
        boolean returnValue = session.makeDirectory(address.getPath());
        DirectoryCache.clearCachedDirectory(this.getParentOfPath(directory));
        VFSManager.sendVFSUpdate((VFS)this, (String)directory, (boolean)true);
        return returnValue;
    }

    public InputStream _createInputStream(Object _session, String path, boolean ignoreErrors, Component comp) throws IOException {
        Connection session = FtpVFS.getConnection(_session);
        FtpAddress address = new FtpAddress(path);
        return session.retrieve(address.getPath());
    }

    public OutputStream _createOutputStream(Object _session, String path, Component comp) throws IOException {
        Connection session = FtpVFS.getConnection(_session);
        FtpAddress address = new FtpAddress(path);
        OutputStream out = session.store(address.getPath());
        DirectoryCache.clearCachedDirectory(this.getParentOfPath(path));
        return out;
    }

    public void _finishTwoStageSave(Object _session, Buffer buffer, String path, Component comp) throws IOException {
        Log.log((int)1, (Object)"Run FtpVFS._finishTwoStageSave()", (Object)path);
        Connection session = FtpVFS.getConnection(_session);
        FtpAddress address = new FtpAddress(path);
        int permissions = buffer.getIntegerProperty(PERMISSIONS_PROPERTY, 0);
        if (permissions != 0) {
            session.chmod(address.getPath(), permissions);
        }
    }

    public void _saveComplete(Object session, Buffer buffer, String path, Component comp) throws IOException {
    }

    public void _backup(Object session, String path, Component comp) throws IOException {
        if (StandardUtilities.compareStrings((String)jEdit.getBuild(), (String)"05.00.00.00", (boolean)false) > 0) {
            super._backup(session, path, comp);
            return;
        }
        Buffer buffer = jEdit.getBuffer((String)path);
        if (buffer == null) {
            return;
        }
        String backPath = this.getBackupFilepath(path);
        if (backPath == null) {
            return;
        }
        File f = new File(backPath);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists() && !f.canWrite()) {
            Log.log((int)9, (Object)((Object)this), (Object)("Can't write file " + backPath));
            return;
        }
        ThreadUtilities.runInBackground((Task)new LocalFileSaveTask(f, buffer.getText(), buffer.getStringProperty("encoding")));
    }

    private String getBackupFilepath(String path) {
        String backupDir = jEdit.getProperty((String)"backup.directory");
        if (backupDir == null || backupDir.equals("")) {
            return null;
        }
        FtpAddress uri = new FtpAddress(path);
        String backFile = "_" + uri.getScheme() + "_" + uri.getUser() + "@" + uri.getHost() + uri.getPath();
        return MiscUtilities.concatPath((String)backupDir, (String)backFile);
    }

    private static Connection getConnection(Object _session) throws IOException {
        FtpSession session = (FtpSession)_session;
        if (session.connection == null) {
            session.connection = ConnectionManager.getConnection(session.info);
        }
        return session.connection;
    }

    private void resolveSymlink(Object _session, String url, FtpDirectoryEntry entry) throws IOException {
        Connection session = FtpVFS.getConnection(_session);
        String path = this.constructPath(url, entry.getName());
        String[] nameArray = new String[]{entry.getName()};
        String link = session.resolveSymlink(new FtpAddress(path).getPath(), nameArray);
        entry.setName(nameArray[0]);
        if (link == null) {
            entry.setPath(path);
            entry.setType(0);
        } else {
            FtpDirectoryEntry linkDirEntry;
            link = this.constructPath(url, link);
            try {
                linkDirEntry = (FtpDirectoryEntry)this._getFile(_session, link, null);
            }
            catch (IOException io) {
                linkDirEntry = null;
            }
            if (linkDirEntry == null) {
                entry.setType(0);
            } else if (linkDirEntry.getType() == 10) {
                Log.log((int)7, (Object)((Object)this), (Object)(entry.getName() + ": Not following more than one symbolic link"));
                entry.setType(0);
                entry.permissions = 600;
            } else {
                entry.setType(linkDirEntry.getType());
                entry.permissions = linkDirEntry.permissions;
            }
            entry.setPath(link);
            entry.setDeletePath(path);
        }
    }

    static class FtpDirectoryEntry
    extends VFSFile {
        public static final int LINK = 10;
        int permissions;
        String permissionString;
        private String ownerUser;
        private String ownerGroup;
        private String modifiedDateStr;

        public FtpDirectoryEntry(String name, String path, String deletePath, int type, long length, boolean hidden, int permissions, String permissionString) {
            super(name, path, deletePath, type, length, hidden);
            this.permissions = permissions;
            this.permissionString = permissionString;
        }

        public String getExtendedAttribute(String name) {
            if (name.equals(FtpVFS.EA_OWNER_USER)) {
                return this.ownerUser;
            }
            if (name.equals(FtpVFS.EA_OWNER_GROUP)) {
                return this.ownerGroup;
            }
            if (name.equals("modified")) {
                return this.modifiedDateStr;
            }
            if (name.equals("type") || name.equals("size")) {
                return super.getExtendedAttribute(name);
            }
            if (name.equals("status")) {
                return this.permissionString;
            }
            return null;
        }

        public void setModifiedDate(String modified) {
            this.modifiedDateStr = modified;
        }

        public void setOwner(String name, String group) {
            this.ownerUser = name == null || name.equals("") ? null : name;
            this.ownerGroup = group == null || group.equals("") ? null : group;
        }
    }

    static class FtpSession {
        ConnectionInfo info;
        Connection connection;

        FtpSession(ConnectionInfo info) {
            this.info = info;
        }
    }
}

