/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import com.fooware.net.FtpClient;
import com.fooware.net.FtpInputStream;
import com.fooware.net.FtpOutputStream;
import com.fooware.net.FtpReader;
import com.fooware.net.FtpResponse;
import com.fooware.net.proxy.ProxyHTTP;
import ftp.Connection;
import ftp.ConnectionInfo;
import ftp.FtpException;
import ftp.FtpLoginException;
import ftp.FtpVFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class FtpConnection
extends Connection {
    private FtpClient client;
    private String prevLine;
    private static Pattern[] unixRegexps = new Pattern[jEdit.getIntegerProperty((String)"vfs.ftp.list.count", (int)-1)];
    private static Pattern dosRegexp;
    private static Pattern vmsRegexp;
    private static Pattern vmsPartialRegexp;
    private static Pattern vmsRejectedRegexp;
    private static Pattern as400Regexp;

    FtpConnection(ConnectionInfo info) throws IOException {
        super(info);
        int index;
        String msg;
        FtpResponse response;
        if (jEdit.getBooleanProperty((String)"vfs.ftp.useProxy") && jEdit.getBooleanProperty((String)"vfs.ftp.passive") && jEdit.getBooleanProperty((String)"firewall.enabled")) {
            ProxyHTTP proxy = jEdit.getProperty((String)"firewall.user", (String)"").equals("") ? new ProxyHTTP(jEdit.getProperty((String)"firewall.host"), jEdit.getIntegerProperty((String)"firewall.port", (int)3128)) : new ProxyHTTP(jEdit.getProperty((String)"firewall.host"), jEdit.getIntegerProperty((String)"firewall.port", (int)3128), jEdit.getProperty((String)"firewall.user"), jEdit.getProperty((String)"firewall.password"));
            this.client = new FtpClient(proxy);
        } else {
            this.client = new FtpClient();
        }
        this.client.connect(info.host, info.port);
        if (!this.client.getResponse().isPositiveCompletion()) {
            throw new FtpException(this.client.getResponse());
        }
        this.client.userName(info.user);
        if (this.client.getResponse().isPositiveIntermediary()) {
            this.client.password(info.getPassword());
            response = this.client.getResponse();
            if (!response.isPositiveCompletion()) {
                this.client.logout();
                throw new FtpLoginException(response);
            }
        } else if (!this.client.getResponse().isPositiveCompletion()) {
            response = this.client.getResponse();
            this.client.logout();
            throw new FtpLoginException(response);
        }
        this.client.printWorkingDirectory();
        response = this.client.getResponse();
        if (response != null && response.getReturnCode() != null && response.getReturnCode().charAt(0) == '2' && (msg = response.getMessage().substring(4)).startsWith("\"") && (index = msg.indexOf(34, 1)) != -1) {
            this.home = msg.substring(1, index);
            if (!this.home.startsWith("/")) {
                this.home = "/".concat(this.home);
            }
        }
    }

    @Override
    FtpVFS.FtpDirectoryEntry[] listDirectory(String path) throws IOException {
        this.client.changeWorkingDirectory(path);
        FtpResponse response = this.client.getResponse();
        if (response != null && response.getReturnCode() != null && response.getReturnCode().charAt(0) != '2') {
            throw new FtpException(response);
        }
        ArrayList<FtpVFS.FtpDirectoryEntry> directoryVector = this._listDirectory(true);
        if (directoryVector == null || directoryVector.size() == 0) {
            directoryVector = this._listDirectory(false);
        }
        if (directoryVector == null) {
            return null;
        }
        return directoryVector.toArray(new FtpVFS.FtpDirectoryEntry[directoryVector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    FtpVFS.FtpDirectoryEntry getDirectoryEntry(String path) throws IOException {
        int type;
        FtpVFS.FtpDirectoryEntry dirEntry;
        String parentPath = MiscUtilities.getParentOfPath((String)path);
        this.client.changeWorkingDirectory(parentPath);
        FtpResponse response = this.client.getResponse();
        if (response != null && response.getReturnCode() != null && response.getReturnCode().charAt(0) != '2') {
            throw new FtpException(response);
        }
        this.setupSocket();
        String name = MiscUtilities.getFileName((String)path);
        FtpReader _reader = this.client.list(name);
        if (_reader == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(_reader);
        LinkedList<FtpVFS.FtpDirectoryEntry> listing = new LinkedList<FtpVFS.FtpDirectoryEntry>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                dirEntry = this.lineToDirectoryEntry(line);
                if (dirEntry != null) {
                    listing.add(dirEntry);
                    continue;
                }
                Log.log((int)1, (Object)this, (Object)("Discarding " + line));
            }
        }
        finally {
            reader.close();
        }
        if (listing.size() == 0) {
            type = 0;
        } else if (listing.size() > 1) {
            type = 1;
        } else {
            dirEntry = (FtpVFS.FtpDirectoryEntry)((Object)listing.get(0));
            if (dirEntry.getName().startsWith(name)) {
                dirEntry.setWriteable(true);
                dirEntry.setReadable(true);
                return dirEntry;
            }
            type = 0;
        }
        dirEntry = new FtpVFS.FtpDirectoryEntry(null, null, null, type, 0L, false, 0, null);
        dirEntry.setWriteable(true);
        dirEntry.setReadable(true);
        return dirEntry;
    }

    @Override
    boolean removeFile(String path) throws IOException {
        this.client.delete(path);
        return this.client.getResponse().isPositiveCompletion();
    }

    @Override
    boolean removeDirectory(String path) throws IOException {
        this.client.removeDirectory(path);
        return this.client.getResponse().isPositiveCompletion();
    }

    @Override
    boolean rename(String from, String to) throws IOException {
        this.client.renameFrom(from);
        this.client.renameTo(to);
        return this.client.getResponse().isPositiveCompletion();
    }

    @Override
    boolean makeDirectory(String path) throws IOException {
        this.client.makeDirectory(path);
        return this.client.getResponse().isPositiveCompletion();
    }

    @Override
    InputStream retrieve(String path) throws IOException {
        this.setupSocket();
        FtpInputStream in = this.client.retrieveStream(path);
        if (in == null) {
            throw new FtpException(this.client.getResponse());
        }
        return in;
    }

    @Override
    OutputStream store(String path) throws IOException {
        this.setupSocket();
        FtpOutputStream out = this.client.storeStream(path);
        if (out == null) {
            throw new FtpException(this.client.getResponse());
        }
        return out;
    }

    @Override
    void chmod(String path, int permissions) throws IOException {
        String cmd = "CHMOD " + Integer.toString(permissions, 8) + " " + path;
        this.client.siteParameters(cmd);
    }

    @Override
    public String resolveSymlink(String path, String[] name) throws IOException {
        String _name = name[0];
        int index = _name.indexOf(" -> ");
        if (index == -1) {
            Log.log((int)5, (Object)this, (Object)("File '" + name + "' is listed as a link, but will be treated" + " as a file because no '->' was found."));
            return null;
        }
        String link = _name.substring(index + " -> ".length());
        name[0] = _name.substring(0, index);
        return link;
    }

    @Override
    boolean checkIfOpen() throws IOException {
        try {
            this.client.noOp();
            this.client.getResponse();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    void logout() throws IOException {
        this.client.logout();
    }

    private void setupSocket() throws IOException {
        if (jEdit.getBooleanProperty((String)"vfs.ftp.binary")) {
            this.client.representationType('I');
        } else {
            this.client.representationType('A');
        }
        if (jEdit.getBooleanProperty((String)"vfs.ftp.passive")) {
            this.client.passive();
        } else {
            this.client.dataPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<FtpVFS.FtpDirectoryEntry> _listDirectory(boolean tryHiddenFiles) throws IOException {
        BufferedReader in = null;
        try {
            String line;
            FtpReader _in;
            ArrayList<FtpVFS.FtpDirectoryEntry> directoryVector = new ArrayList<FtpVFS.FtpDirectoryEntry>();
            this.setupSocket();
            FtpReader ftpReader = _in = tryHiddenFiles ? this.client.list("-a") : this.client.list();
            if (_in == null) {
                if (!tryHiddenFiles) {
                    throw new FtpException(this.client.getResponse());
                }
                ArrayList<FtpVFS.FtpDirectoryEntry> arrayList = null;
                return arrayList;
            }
            in = new BufferedReader(_in);
            while ((line = in.readLine()) != null) {
                if (line.length() == 0) continue;
                FtpVFS.FtpDirectoryEntry entry = this.lineToDirectoryEntry(line);
                if (entry == null || entry.getName().equals(".") || entry.getName().equals("..")) {
                    Log.log((int)1, (Object)this, (Object)("Discarding " + line));
                    continue;
                }
                directoryVector.add(entry);
            }
            ArrayList<FtpVFS.FtpDirectoryEntry> arrayList = directoryVector;
            return arrayList;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    Log.log((int)9, (Object)this, (Object)e);
                }
            }
        }
    }

    private FtpVFS.FtpDirectoryEntry lineToDirectoryEntry(String line) {
        try {
            Matcher match;
            int type = 0;
            String name = null;
            long length = 0L;
            int permissions = 0;
            String permissionString = null;
            String ownerName = null;
            String ownerGroup = null;
            boolean ok = false;
            if (this.prevLine != null) {
                line = this.prevLine + line;
                this.prevLine = null;
            }
            for (int i = 0; i < unixRegexps.length; ++i) {
                Pattern regexp = unixRegexps[i];
                Matcher match2 = regexp.matcher(line);
                if (match2 == null || !match2.matches()) continue;
                switch (line.charAt(0)) {
                    case 'd': {
                        type = 1;
                        break;
                    }
                    case 'l': {
                        type = 10;
                        break;
                    }
                    case '-': {
                        type = 0;
                    }
                }
                permissionString = match2.group(1);
                permissions = MiscUtilities.parsePermissions((String)permissionString);
                ownerName = match2.group(2);
                ownerGroup = match2.group(3);
                try {
                    length = Long.parseLong(match2.group(4));
                }
                catch (NumberFormatException nf) {
                    length = 0L;
                }
                name = match2.group(5);
                ok = true;
                break;
            }
            if (!ok) {
                if (vmsPartialRegexp.matcher(line).matches()) {
                    this.prevLine = line;
                    return null;
                }
                if (vmsRejectedRegexp.matcher(line).matches()) {
                    return null;
                }
                Matcher match3 = vmsRegexp.matcher(line);
                if (match3 != null && match3.matches()) {
                    name = match3.group(1);
                    length = Long.parseLong(match3.group(2)) * 512L;
                    if (name.endsWith(".DIR")) {
                        name = name.substring(0, name.length() - 4);
                        type = 1;
                    }
                    permissionString = match3.group(3);
                    ok = true;
                }
            }
            if (!ok && (match = as400Regexp.matcher(line)) != null && match.matches()) {
                String dirFlag = match.group(2);
                type = dirFlag.equals("*DIR") ? 1 : 0;
                try {
                    length = Long.parseLong(match.group(1));
                }
                catch (NumberFormatException nf) {
                    length = 0L;
                }
                name = match.group(3);
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                ok = true;
            }
            if (!ok && (match = dosRegexp.matcher(line)) != null && match.matches()) {
                try {
                    String sizeStr = match.group(1);
                    if (sizeStr.equals("<DIR>")) {
                        type = 1;
                    } else {
                        length = Long.parseLong(sizeStr);
                    }
                }
                catch (NumberFormatException nf) {
                    length = 0L;
                }
                name = match.group(2);
                ok = true;
            }
            if (!ok) {
                return null;
            }
            FtpVFS.FtpDirectoryEntry result = new FtpVFS.FtpDirectoryEntry(name, null, null, type, length, name.charAt(0) == '.', permissions, permissionString);
            result.setOwner(ownerName, ownerGroup);
            return result;
        }
        catch (Exception e) {
            Log.log((int)5, (Object)this, (Object)("lineToDirectoryEntry(" + line + ") failed:"));
            Log.log((int)5, (Object)this, (Object)e);
            return null;
        }
    }

    static {
        for (int i = 0; i < unixRegexps.length; ++i) {
            FtpConnection.unixRegexps[i] = Pattern.compile(jEdit.getProperty((String)("vfs.ftp.list." + i)), 1);
        }
        dosRegexp = Pattern.compile(jEdit.getProperty((String)"vfs.ftp.list.dos"), 1);
        vmsRegexp = Pattern.compile(jEdit.getProperty((String)"vfs.ftp.list.vms"), 1);
        vmsPartialRegexp = Pattern.compile(jEdit.getProperty((String)"vfs.ftp.list.vms.partial"), 1);
        vmsRejectedRegexp = Pattern.compile(jEdit.getProperty((String)"vfs.ftp.list.vms.rejected"), 1);
        as400Regexp = Pattern.compile(jEdit.getProperty((String)"vfs.ftp.list.as400"), 1);
    }
}

