/*
 * Decompiled with CFR 0.152.
 */
package ftp;

public class FtpAddress {
    private String scheme;
    private String host;
    private int port;
    private String path;
    private String user;
    private String password;

    public FtpAddress(String url) {
        String domainPart;
        if (url.startsWith("ftp://")) {
            this.scheme = "ftp";
        } else if (url.startsWith("sftp://")) {
            this.scheme = "sftp";
        } else {
            throw new IllegalArgumentException("Unsupported URI scheme");
        }
        int pos = url.indexOf(47, this.scheme.length() + 3);
        if (pos == -1) {
            this.setPath("");
            domainPart = url.substring(this.scheme.length() + 3, url.length());
        } else {
            this.setPath(url.substring(pos));
            domainPart = url.substring(this.scheme.length() + 3, pos);
        }
        pos = domainPart.lastIndexOf(64);
        if (pos == -1) {
            Object authPart = null;
        } else {
            String authPart = domainPart.substring(0, pos);
            domainPart = domainPart.substring(pos + 1);
            pos = authPart.indexOf(58);
            if (pos == -1) {
                this.user = authPart;
                this.password = null;
            } else {
                this.user = authPart.substring(0, pos);
                this.password = authPart.substring(pos + 1);
            }
        }
        pos = domainPart.lastIndexOf(58);
        if (pos == -1) {
            this.host = domainPart;
            this.port = this.getDefaultPort();
        } else {
            this.host = domainPart.substring(0, pos);
            try {
                this.port = Integer.parseInt(domainPart.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid connection port: '" + domainPart.substring(pos + 1) + "'", e);
            }
        }
        this.host = this.host.replace(" ", "");
    }

    public FtpAddress(boolean secure, String host, String user, String path) {
        this.host = host.replace(" ", "");
        this.user = user;
        this.setPath(path);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.scheme);
        buf.append("://");
        if (this.user != null) {
            buf.append(this.user);
            buf.append('@');
        }
        buf.append(this.host);
        buf.append(":");
        buf.append(this.port);
        buf.append(this.path);
        return buf.toString();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private int getDefaultPort() {
        return this.scheme == "sftp" ? 22 : 21;
    }

    public boolean isSecure() {
        return this.scheme == "sftp";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : path.trim();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

