/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class DirectoryCache {
    private static Object lock = new Object();
    private static int tmpFileCount;
    private static Hashtable<String, String> urlToCacheFileHash;
    private static String cacheDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFSFile[] getCachedDirectory(String url) {
        url = DirectoryCache.canon(url);
        Object object = lock;
        synchronized (object) {
            VFSFile[] vFSFileArray;
            String path = urlToCacheFileHash.get(url);
            if (path == null) {
                return null;
            }
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));
                vFSFileArray = (VFSFile[])in.readObject();
            }
            catch (Exception e) {
                VFSFile[] vFSFileArray2;
                try {
                    Log.log((int)9, DirectoryCache.class, (Object)e);
                    vFSFileArray2 = null;
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(in);
                    throw throwable;
                }
                IOUtilities.closeQuietly((Closeable)in);
                return vFSFileArray2;
            }
            IOUtilities.closeQuietly((Closeable)in);
            return vFSFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCachedDirectory(String url, VFSFile[] directory) {
        if (cacheDirectory == null) {
            return;
        }
        url = DirectoryCache.canon(url);
        Object object = lock;
        synchronized (object) {
            long time = System.currentTimeMillis();
            String path = MiscUtilities.constructPath((String)cacheDirectory, (String)("cache-" + ++tmpFileCount + "-" + time + ".tmp"));
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
                out.writeObject(directory);
                Log.log((int)1, DirectoryCache.class, (Object)("Cached " + url + " to " + path));
                urlToCacheFileHash.put(url, path);
                IOUtilities.closeQuietly((Closeable)out);
            }
            catch (Exception e) {
                Log.log((int)9, DirectoryCache.class, (Object)e);
            }
            finally {
                IOUtilities.closeQuietly(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCachedDirectory(String url) {
        url = DirectoryCache.canon(url);
        Object object = lock;
        synchronized (object) {
            Enumeration<String> e = urlToCacheFileHash.keys();
            while (e.hasMoreElements()) {
                String path = e.nextElement();
                if (!path.startsWith(url)) continue;
                String cacheFile = urlToCacheFileHash.remove(path);
                Log.log((int)1, DirectoryCache.class, (Object)("Deleting " + cacheFile));
                new File(cacheFile).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllCachedDirectories() {
        Object object = lock;
        synchronized (object) {
            Enumeration<String> files = urlToCacheFileHash.elements();
            while (files.hasMoreElements()) {
                String path = files.nextElement();
                Log.log((int)1, DirectoryCache.class, (Object)("Deleting " + path));
                new File(path).delete();
            }
            urlToCacheFileHash.clear();
        }
    }

    private DirectoryCache() {
    }

    private static String canon(String url) {
        if (url.length() != 0 && (url.endsWith("/") || url.endsWith(File.separator))) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    static {
        urlToCacheFileHash = new Hashtable();
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            Log.log((int)7, DirectoryCache.class, (Object)"-nosettings command line switch specified; remote directories");
            Log.log((int)7, DirectoryCache.class, (Object)"will not be cached.");
        } else {
            cacheDirectory = MiscUtilities.constructPath((String)settingsDirectory, (String)"cache");
            new File(cacheDirectory).mkdirs();
        }
    }
}

