/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import com.jcraft.jsch.JSch;
import ftp.Connection;
import ftp.ConnectionInfo;
import ftp.DirectoryCache;
import ftp.FtpAddress;
import ftp.FtpConnection;
import ftp.FtpVFS;
import ftp.LoginDialog;
import ftp.PasswordDialog;
import ftp.SFtpConnection;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JFrame;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class ConnectionManager {
    protected static Object lock;
    protected static boolean restoredPasswords;
    protected static ArrayList<Connection> connections;
    protected static HashMap<String, ConnectionInfo> logins;
    private static HashMap<String, String> passwords;
    private static HashMap<String, String> passphrases;
    static byte[] masterKey;
    static int connectionTimeout;
    private static File passwordFile;
    public static JSch client;

    public static void forgetPasswords() {
        try {
            if (client != null) {
                client.removeAllIdentity();
            }
            if (passwordFile.exists()) {
                passwordFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        masterKey = null;
        ConnectionManager.saveKeyFile();
        restoredPasswords = false;
        passwords.clear();
        passphrases.clear();
        logins.clear();
        client = null;
    }

    protected static String getPassword(String hostInfo) {
        if (!restoredPasswords) {
            ConnectionManager.loadPasswords();
        }
        return passwords.get(hostInfo);
    }

    protected static void setPassword(String hostInfo, String password) {
        passwords.put(hostInfo, password);
        ConnectionManager.savePasswords();
    }

    public static String getPassphrase(String keyFile) {
        if (!restoredPasswords) {
            ConnectionManager.loadPasswords();
        }
        return passphrases.get(keyFile);
    }

    public static void setPassphrase(String keyFile, String passphrase) {
        passphrases.put(keyFile, passphrase);
        ConnectionManager.savePasswords();
    }

    public static String getStoredFtpKey(String hostport, String user) {
        String s = jEdit.getProperty((String)("ftp.keys." + hostport + "." + user));
        if (s == null || s.length() <= 0) {
            return null;
        }
        return new File(s).exists() ? s : null;
    }

    protected static void getKeyFile() {
        if (!jEdit.getBooleanProperty((String)"ftp.useKeyFile")) {
            return;
        }
        try {
            File f = new File(jEdit.getProperty((String)"ftp.passKeyFile"));
            if (!f.exists()) {
                return;
            }
            int length = (int)f.length();
            masterKey = new byte[length];
            FileInputStream fis = new FileInputStream(f);
            fis.read(masterKey);
            fis.close();
        }
        catch (Exception e) {
            Log.log((int)9, ConnectionManager.class, (Object)e);
        }
    }

    protected static void saveKeyFile() {
        if (!jEdit.getBooleanProperty((String)"ftp.useKeyFile")) {
            return;
        }
        try {
            File f = new File(jEdit.getProperty((String)"ftp.passKeyFile"));
            if (masterKey == null) {
                f.delete();
                return;
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(masterKey);
            fos.close();
        }
        catch (Exception e) {
            Log.log((int)9, ConnectionManager.class, (Object)e);
        }
    }

    protected static boolean promptMasterPassword() {
        return ConnectionManager.promptMasterPassword(jEdit.getProperty((String)"login.masterpassword.title"), jEdit.getProperty((String)"login.masterpassword.message"));
    }

    protected static boolean promptMasterPasswordCreate() {
        return ConnectionManager.promptMasterPassword(jEdit.getProperty((String)"login.masterpassword.title"), jEdit.getProperty((String)"login.masterpassword.message.create"));
    }

    protected static boolean promptMasterPassword(final String title, final String message) {
        if (!jEdit.getBooleanProperty((String)"vfs.ftp.storePassword")) {
            return false;
        }
        ConnectionManager.getKeyFile();
        if (masterKey != null) {
            return true;
        }
        try {
            ThreadUtilities.runInDispatchThreadAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    PasswordDialog pd = new PasswordDialog((JFrame)jEdit.getActiveView(), title, message);
                    if (!pd.isOK()) {
                        jEdit.setBooleanProperty((String)"vfs.ftp.storePassword", (boolean)false);
                        String msg2 = jEdit.getProperty((String)"ftp.cancel-master-password");
                        Log.log((int)3, ConnectionManager.class, (Object)msg2);
                        jEdit.getActiveView().getStatus().setMessage(msg2);
                        return;
                    }
                    String masterPassword = new String(pd.getPassword());
                    if (masterPassword.isEmpty()) {
                        return;
                    }
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        masterKey = digest.digest(masterPassword.getBytes("utf-8"));
                    }
                    catch (Exception e) {
                        Log.log((int)9, ConnectionManager.class, (Object)e, (Throwable)e);
                        return;
                    }
                    ConnectionManager.saveKeyFile();
                }
            });
        }
        catch (Exception e) {
            Log.log((int)9, ConnectionManager.class, (Object)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadPasswords() {
        if (!jEdit.getBooleanProperty((String)"vfs.ftp.storePassword")) {
            return;
        }
        if (passwordFile == null) {
            Log.log((int)7, ConnectionManager.class, (Object)"Password File is null - unable to load passwords.");
            return;
        }
        if (!passwordFile.exists()) {
            return;
        }
        int passwordFileLength = (int)passwordFile.length();
        if (passwordFileLength == 0) {
            return;
        }
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        int i = 0;
        while (!restoredPasswords) {
            block19: {
                block18: {
                    try {
                        if (masterKey == null) {
                            if (i == 0 && !ConnectionManager.promptMasterPassword()) {
                                return;
                            }
                            if (i > 0 && !ConnectionManager.promptMasterPassword(jEdit.getProperty((String)"ftp.bad-master-password"), jEdit.getProperty((String)"login.masterpassword.message"))) {
                                IOUtilities.closeQuietly((Closeable)fis);
                                break block18;
                            }
                        }
                        ++i;
                        byte[] buffer = new byte[passwordFileLength];
                        fis = new FileInputStream(passwordFile);
                        for (int read = 0; read < passwordFileLength; read += fis.read(buffer, read, passwordFileLength - read)) {
                        }
                        Cipher c = ConnectionManager.getCipher(2);
                        byte[] objectBuffer = c.doFinal(buffer);
                        ois = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(objectBuffer, 0, objectBuffer.length)));
                        passwords = (HashMap)ois.readObject();
                        passphrases = (HashMap)ois.readObject();
                        Log.log((int)1, ConnectionManager.class, (Object)("Passwords loaded: " + passwords.size()));
                        Log.log((int)1, ConnectionManager.class, (Object)("Passphrases loaded: " + passphrases.size()));
                        restoredPasswords = true;
                        IOUtilities.closeQuietly((Closeable)fis);
                        break block19;
                    }
                    catch (BadPaddingException bpe) {
                        masterKey = null;
                        ConnectionManager.saveKeyFile();
                        continue;
                    }
                    catch (Exception e) {
                        Log.log((int)9, ConnectionManager.class, (Object)"loadPasswords()", (Throwable)e);
                        return;
                    }
                }
                IOUtilities.closeQuietly(ois);
                return;
            }
            IOUtilities.closeQuietly((Closeable)ois);
            continue;
            finally {
                IOUtilities.closeQuietly(fis);
                IOUtilities.closeQuietly(ois);
            }
        }
    }

    protected static Cipher getCipher(int opmode) throws Exception {
        String TRANSFORMATION = "AES";
        try {
            Cipher c = Cipher.getInstance(TRANSFORMATION);
            SecretKeySpec k = new SecretKeySpec(masterKey, TRANSFORMATION);
            c.init(opmode, k);
            return c;
        }
        catch (Exception ike) {
            if (jEdit.getBooleanProperty((String)"ftp.disableWeakCrypto")) {
                String msg = jEdit.getProperty((String)"ftp.jce.strongkeys.missing");
                Log.log((int)9, ConnectionManager.class, (Object)msg, (Throwable)ike);
                jEdit.setBooleanProperty((String)"vfs.ftp.storePassword", (boolean)false);
                jEdit.getActiveView().getStatus().setMessage(msg);
                return null;
            }
            Log.log((int)7, ConnectionManager.class, (Object)jEdit.getProperty((String)"ftp.using.weak-crypto"));
            TRANSFORMATION = "DES";
            DESKeySpec keySpec = new DESKeySpec(masterKey);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(TRANSFORMATION);
            SecretKey k = keyFac.generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(opmode, k);
            return cipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void savePasswords() {
        if (!jEdit.getBooleanProperty((String)"vfs.ftp.storePassword")) {
            return;
        }
        if (passwordFile == null) {
            Log.log((int)7, ConnectionManager.class, (Object)"Password File is null - unable to save passwords.");
            return;
        }
        if (masterKey == null && !ConnectionManager.promptMasterPasswordCreate()) {
            return;
        }
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(passwords);
            oos.writeObject(passphrases);
            byte[] objectBuffer = baos.toByteArray();
            Cipher c = ConnectionManager.getCipher(1);
            objectBuffer = c.doFinal(objectBuffer);
            int newLength = objectBuffer.length;
            fos = new FileOutputStream(passwordFile);
            fos.write(objectBuffer, 0, newLength);
            Log.log((int)1, ConnectionManager.class, (Object)("Passwords saved: " + passwords.size()));
            Log.log((int)1, ConnectionManager.class, (Object)("Passphrases saved: " + passphrases.size()));
        }
        catch (Exception e) {
            try {
                Log.log((int)9, ConnectionManager.class, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(oos);
                IOUtilities.closeQuietly((Closeable)baos);
                IOUtilities.closeQuietly(fos);
                throw throwable;
            }
            IOUtilities.closeQuietly((Closeable)oos);
            IOUtilities.closeQuietly((Closeable)baos);
            IOUtilities.closeQuietly(fos);
        }
        IOUtilities.closeQuietly((Closeable)oos);
        IOUtilities.closeQuietly((Closeable)baos);
        IOUtilities.closeQuietly((Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeUnusedConnections() {
        Object object = lock;
        synchronized (object) {
            for (int i = 0; i < connections.size(); ++i) {
                Connection _connect = connections.get(i);
                if (_connect.inUse()) continue;
                ConnectionManager.closeConnection(_connect);
                --i;
            }
        }
    }

    public static ConnectionInfo getConnectionInfo(Component comp, FtpAddress address, boolean _secure) {
        boolean secure;
        String password;
        String user;
        String hostport;
        Log.log((int)1, (Object)"ConnectionManager.getConnectionInfo", (Object)address);
        if (address != null) {
            hostport = address.getHost() + ":" + address.getPort();
            user = address.getUser();
            password = address.getPassword();
            secure = address.isSecure();
            ConnectionInfo info = logins.get(hostport);
            if (info != null) {
                return info;
            }
            String key = ConnectionManager.getStoredFtpKey(hostport, user);
            if (hostport != null && user != null && (password != null || key != null)) {
                info = new ConnectionInfo(address.isSecure(), address.getHost(), address.getPort(), user, password, key);
                logins.put(hostport, info);
                return info;
            }
        } else {
            password = null;
            user = null;
            hostport = null;
            secure = _secure;
        }
        GUIUtilities.hideSplashScreen();
        final LoginDialog dialog = new LoginDialog(comp, secure, hostport, user, password);
        ThreadUtilities.runInDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
        if (!dialog.isOK()) {
            return null;
        }
        String host = dialog.getHost();
        int port = FtpVFS.getDefaultPort(secure);
        int index = host.indexOf(58);
        if (index != -1) {
            try {
                port = Integer.parseInt(host.substring(index + 1));
                host = host.substring(0, index);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ConnectionInfo info = new ConnectionInfo(secure, host, port, dialog.getUser(), dialog.getPassword(), dialog.getPrivateKeyFilename());
        if (secure && dialog.getPrivateKeyFilename() != null) {
            jEdit.setProperty((String)("ftp.keys." + host + ":" + port + "." + dialog.getUser()), (String)dialog.getPrivateKeyFilename());
        }
        if (jEdit.getBooleanProperty((String)"vfs.ftp.storePassword")) {
            ConnectionManager.setPassword(host + ":" + port + "." + dialog.getUser(), dialog.getPassword());
        }
        logins.put(host + ":" + port, info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(ConnectionInfo info) throws IOException {
        Connection connect = null;
        Object object = lock;
        synchronized (object) {
            for (Connection conn : connections) {
                if (!conn.info.equals(info) || conn.inUse()) continue;
                connect = conn;
                if (connect.checkIfOpen()) break;
                Log.log((int)1, ConnectionManager.class, (Object)("Connection " + connect + " expired"));
                connect.logoutQuietly();
                connections.remove(connect);
                connect = null;
            }
            if (connect != null) {
                Log.log((int)1, ConnectionManager.class, (Object)("Connection found in cache [" + connect + "]"));
                connect.lock();
                return connect;
            }
            int retries = 0;
            while (connect == null) {
                Log.log((int)1, ConnectionManager.class, (Object)(Thread.currentThread() + ": Connecting to " + info));
                try {
                    connect = info.secure ? new SFtpConnection(info) : new FtpConnection(info);
                    connections.add(connect);
                    connect.lock();
                    return connect;
                }
                catch (IOException e) {
                    Log.log((int)7, ConnectionManager.class, (Object)("catch " + e.getClass().getName() + " on " + info), (Throwable)e);
                    info.privateKey = null;
                    info.password = null;
                    jEdit.unsetProperty((String)("ftp.keys." + info.host + ":" + info.port + "." + info.user));
                    if (++retries <= 3) continue;
                    throw e;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(Connection connect) {
        Log.log((int)1, ConnectionManager.class, (Object)("releaseConnection(" + connect + ")"));
        if (connect == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            connect.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeConnection(Connection connect) {
        Object object = lock;
        synchronized (object) {
            if (connect.inUse()) {
                Log.log((int)1, ConnectionManager.class, (Object)"Can't close connection that still in use");
                return;
            }
            Log.log((int)1, ConnectionManager.class, (Object)("Closing connection to " + connect.info));
            connect.logoutQuietly();
            connections.remove(connect);
        }
    }

    public static void cleanup() {
        DirectoryCache.clearAllCachedDirectories();
        for (Connection c : connections) {
            c.logoutQuietly();
        }
        try {
            client.removeAllIdentity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        connections.clear();
        logins.clear();
        passwords.clear();
        passphrases.clear();
        masterKey = null;
        restoredPasswords = false;
        client = null;
    }

    static {
        restoredPasswords = false;
        masterKey = null;
        connectionTimeout = 60000;
        passwordFile = null;
        client = null;
        restoredPasswords = false;
        lock = new Object();
        connections = new ArrayList();
        logins = new HashMap();
        passwords = new HashMap();
        passphrases = new HashMap();
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            Log.log((int)7, ConnectionManager.class, (Object)"-nosettings command line switch specified;");
            Log.log((int)7, ConnectionManager.class, (Object)"passwords will not be saved.");
        } else {
            String passwordDirectory = MiscUtilities.constructPath((String)settingsDirectory, (String)"cache");
            passwordFile = new File(MiscUtilities.constructPath((String)passwordDirectory, (String)"password-cache"));
            passwordFile.getParentFile().mkdirs();
            try {
                passwordFile.createNewFile();
            }
            catch (IOException e) {
                Log.log((int)7, ConnectionManager.class, (Object)("Unable to create password file: " + passwordFile));
                passwordFile = null;
            }
        }
    }
}

