/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import ftp.ConnectionInfo;
import ftp.ConnectionManager;
import ftp.FtpVFS;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Timer;
import org.gjt.sp.util.Log;

public abstract class Connection {
    static int COUNTER;
    int id = COUNTER++;
    ConnectionInfo info;
    String home;
    Timer closeTimer;
    private boolean inUse;

    Connection(ConnectionInfo info) {
        this.info = info;
        this.closeTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionManager.closeConnection(Connection.this);
            }
        });
    }

    abstract FtpVFS.FtpDirectoryEntry[] listDirectory(String var1) throws IOException;

    abstract FtpVFS.FtpDirectoryEntry getDirectoryEntry(String var1) throws IOException;

    abstract boolean removeFile(String var1) throws IOException;

    abstract boolean removeDirectory(String var1) throws IOException;

    abstract boolean rename(String var1, String var2) throws IOException;

    abstract boolean makeDirectory(String var1) throws IOException;

    abstract InputStream retrieve(String var1) throws IOException;

    abstract OutputStream store(String var1) throws IOException;

    abstract void chmod(String var1, int var2) throws IOException;

    abstract boolean checkIfOpen() throws IOException;

    abstract String resolveSymlink(String var1, String[] var2) throws IOException;

    abstract void logout() throws IOException;

    public void logoutQuietly() {
        try {
            this.logout();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean inUse() {
        return this.inUse;
    }

    void lock() {
        if (this.inUse) {
            throw new InternalError("Trying to lock connection twice!");
        }
        Log.log((int)1, ConnectionManager.class, (Object)(Thread.currentThread() + ": Connection " + this + " locked"));
        this.inUse = true;
        this.closeTimer.stop();
    }

    void unlock() {
        if (!this.inUse) {
            Log.log((int)9, ConnectionManager.class, (Object)new Exception(Thread.currentThread() + ": Trying to release connection twice!"));
        } else {
            Log.log((int)1, ConnectionManager.class, (Object)(Thread.currentThread() + ": Connection " + this + " released"));
        }
        this.inUse = false;
        this.closeTimer.stop();
        this.closeTimer.setInitialDelay(ConnectionManager.connectionTimeout);
        this.closeTimer.setRepeats(false);
        this.closeTimer.start();
    }

    public String toString() {
        return this.id + ":" + this.info.host;
    }
}

