/*
 * Decompiled with CFR 0.152.
 */
package com.fooware.net.proxy;

import com.fooware.net.proxy.Proxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import sun.misc.BASE64Encoder;

public class ProxyHTTP
implements Proxy {
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPass;

    public ProxyHTTP(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    public ProxyHTTP(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
    }

    @Override
    public Socket openSocket(String hostName, int port) throws IOException {
        Socket socket = new Socket(this.proxyHost, this.proxyPort);
        socket.setTcpNoDelay(true);
        OutputStream out = socket.getOutputStream();
        InputStream in = socket.getInputStream();
        out.write(("CONNECT " + hostName + ":" + port + " HTTP/1.0\r\n").getBytes());
        if (this.proxyUser != null && this.proxyPass != null) {
            byte[] code = (this.proxyUser + ":" + this.proxyPass).getBytes();
            out.write("Proxy-Authorization: Basic ".getBytes());
            out.write(new BASE64Encoder().encode(code).getBytes());
            out.write("\r\n".getBytes());
        }
        out.write("\r\n".getBytes());
        out.flush();
        int foo = 0;
        StringBuilder sb = new StringBuilder();
        while (foo >= 0) {
            foo = in.read();
            if (foo != 13) {
                sb.append((char)foo);
                continue;
            }
            foo = in.read();
            if (foo != 10) continue;
        }
        if (foo < 0) {
            throw new IOException();
        }
        String response = sb.toString();
        String reason = "Unknow reason";
        int code = -1;
        try {
            foo = response.indexOf(32);
            int bar = response.indexOf(32, foo + 1);
            code = Integer.parseInt(response.substring(foo + 1, bar));
            reason = response.substring(bar + 1);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (code != 200) {
            throw new IOException("proxy error: " + reason);
        }
        int count = 0;
        do {
            count = 0;
            while (foo >= 0) {
                foo = in.read();
                if (foo != 13) {
                    ++count;
                    continue;
                }
                foo = in.read();
                if (foo != 10) continue;
            }
            if (foo >= 0) continue;
            throw new IOException();
        } while (count != 0);
        return socket;
    }
}

