/*
 * Decompiled with CFR 0.152.
 */
package com.fooware.net;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FtpResponse {
    public static final char REPLY_POSITIVE_PRELIMINARY = '1';
    public static final char REPLY_POSITIVE_COMPLETION = '2';
    public static final char REPLY_POSITIVE_INTERMEDIARY = '3';
    public static final char REPLY_TRANSIENT_NEGATIVE_COMPLETION = '4';
    public static final char REPLY_PERMANENT_NEGATIVE_COMPLETION = '5';
    public static final char REGARDING_SYNTAX = '0';
    public static final char REGARDING_INFORMATION = '1';
    public static final char REGARDING_CONNECTION = '2';
    public static final char REGARDING_AUTHENTICATION = '3';
    public static final char REGARDING_UNSPECIFIED = '4';
    public static final char REGARDING_FILE_SYSTEM = '5';
    private String message;
    private String returnCode;

    FtpResponse(BufferedReader in) throws IOException {
        this.setMessage(in);
    }

    FtpResponse(InputStream istr) throws IOException {
        this.setMessage(istr);
    }

    public String getMessage() {
        return this.message;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String toString() {
        return this.message;
    }

    public boolean isPositivePreliminary() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(0) == '1';
    }

    public boolean isPositiveCompletion() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(0) == '2';
    }

    public boolean isPositiveIntermediary() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(0) == '3';
    }

    public boolean isTransientNegativeCompletion() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(0) == '4';
    }

    public boolean isPermanentNegativeCompletion() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(0) == '5';
    }

    public boolean isRegardingSyntax() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(1) == '0';
    }

    public boolean isRegardingInformation() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(1) == '1';
    }

    public boolean isRegardingConnection() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(1) == '2';
    }

    public boolean isRegardingAuthentication() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(1) == '3';
    }

    public boolean isRegardingFileSystem() {
        if (this.returnCode == null) {
            return false;
        }
        return this.returnCode.charAt(1) == '5';
    }

    private void setMessage(BufferedReader in) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if (this.returnCode == null) {
                this.returnCode = line.substring(0, 3);
            }
            buffer.append(line);
            buffer.append('\n');
            if (line.length() <= 3 || !line.startsWith(this.returnCode + " ")) continue;
        }
        this.message = buffer.toString();
    }

    private void setMessage(InputStream istr) throws IOException {
        int read;
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = istr.read(buffer)) != -1) {
            ostr.write(buffer, 0, read);
        }
        ostr.close();
        this.message = ostr.toString();
    }
}

