/*
 * Decompiled with CFR 0.152.
 */
package com.fooware.net;

import com.fooware.net.FtpInputStream;
import com.fooware.net.FtpOutputStream;
import com.fooware.net.FtpReader;
import com.fooware.net.FtpResponse;
import com.fooware.net.FtpWriter;
import com.fooware.net.proxy.Proxy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.gjt.sp.util.Log;

public class FtpClient {
    public static final int TIMEOUT = 45000;
    public static final int DEFAULT_PORT = 21;
    public static final char ASCII_TYPE = 'A';
    public static final char IMAGE_TYPE = 'I';
    public static final char EBCDIC_TYPE = 'E';
    public static final char LOCAL_FORMAT = 'L';
    public static final char NON_PRINT_FORMAT = 'N';
    public static final char TELNET_EFFECTORS_FORMAT = 'T';
    public static final char CARRIAGE_CONTROL_FORMAT = 'C';
    public static final char FILE_STRUCTURE = 'F';
    public static final char RECORD_STRUCTURE = 'R';
    public static final char PAGE_STRUCTURE = 'P';
    public static final char STREAM_MODE = 'S';
    public static final char BLOCK_MODE = 'B';
    public static final char COMPRESSED_MODE = 'C';
    private BufferedReader in;
    private BufferedWriter out;
    private Socket cmdSocket;
    private ServerSocket dataSocket;
    private Socket dataXfrSocket;
    private Socket passiveSocket;
    private FtpResponse response;
    private Vector<FtpResponse> responseArchive = new Vector();
    private Proxy proxy;

    public FtpClient() {
    }

    public FtpClient(Proxy proxy) {
        this.proxy = proxy;
    }

    public void sendCommand(String command) throws IOException {
        String debugString = command;
        if (command.startsWith("PASS")) {
            debugString = "PASS <password removed for security>";
        }
        this.debug("sending command", debugString);
        this.out.write(command);
        this.out.write("\r\n");
        this.out.flush();
        this.setResponse();
    }

    public FtpResponse getResponse() {
        return this.response;
    }

    public Enumeration<FtpResponse> getAllResponses() {
        return this.responseArchive.elements();
    }

    public void connect(String hostName) throws IOException {
        this.connect(hostName, 21);
    }

    public void connect(String hostName, int port) throws IOException {
        this.cmdSocket = this.proxy != null ? this.proxy.openSocket(hostName, port) : new Socket(hostName, port);
        this.cmdSocket.setSoTimeout(45000);
        this.in = new BufferedReader(new InputStreamReader(this.cmdSocket.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.cmdSocket.getOutputStream()));
        this.setResponse();
    }

    public void userName(String userName) throws IOException {
        this.sendCommand("USER " + userName);
    }

    public void password(String password) throws IOException {
        this.sendCommand("PASS " + password);
    }

    public void account(String account) throws IOException {
        this.sendCommand("ACCT " + account);
    }

    public void changeWorkingDirectory(String path) throws IOException {
        this.sendCommand("CWD " + path);
    }

    public void changeToParentDirectory() throws IOException {
        this.sendCommand("CDUP");
    }

    public void structureMount(String path) throws IOException {
        this.sendCommand("SMNT " + path);
    }

    public void reinitialize() throws IOException {
        this.sendCommand("REIN");
    }

    public void logout() throws IOException {
        this.sendCommand("QUIT");
    }

    public void dataPort() throws IOException, UnknownHostException {
        StringBuilder command = new StringBuilder("PORT ");
        String host = this.cmdSocket.getLocalAddress().getHostAddress();
        command.append(host.replace('.', ','));
        if (this.dataSocket != null) {
            this.dataSocket.close();
        }
        this.dataSocket = new ServerSocket(0);
        this.dataSocket.setSoTimeout(45000);
        int port = this.dataSocket.getLocalPort();
        command.append(',');
        command.append(port / 256);
        command.append(',');
        command.append(port % 256);
        this.sendCommand(command.toString());
    }

    public void passive() throws IOException {
        this.sendCommand("PASV");
        FtpResponse resp = this.getResponse();
        if (!resp.isPositiveCompletion()) {
            Log.log((int)9, (Object)this, (Object)(Thread.currentThread() + ": Couldn't set passive, trying data port"));
            this.dataPort();
            return;
        }
        try {
            String message = resp.getMessage();
            int bound_r = message.lastIndexOf(41);
            int bound_l = message.lastIndexOf(40, bound_r - 1) + 1;
            String remoteAddr = message.substring(bound_l, bound_r);
            int comma1 = remoteAddr.lastIndexOf(44);
            int port = Integer.parseInt(remoteAddr.substring(comma1 + 1));
            int comma2 = remoteAddr.lastIndexOf(44, comma1 - 1);
            port |= Integer.parseInt(remoteAddr.substring(comma2 + 1, comma1)) << 8;
            remoteAddr = remoteAddr.substring(0, comma2).replace(',', '.');
            this.passiveSocket = this.proxy != null ? this.proxy.openSocket(remoteAddr, port) : new Socket(remoteAddr, port);
            this.passiveSocket.setSoTimeout(45000);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.log((int)9, (Object)this, (Object)(Thread.currentThread() + ": Couldn't set passive, trying data port"));
            this.dataPort();
            return;
        }
    }

    public void representationType(char type, char format) throws IOException {
        if (type == 'I') {
            this.sendCommand("TYPE " + type);
        } else {
            this.sendCommand("TYPE " + type + ' ' + format);
        }
    }

    public void representationType(char type) throws IOException {
        this.representationType(type, 'N');
    }

    public void representationType(int size) throws IOException {
        this.sendCommand("TYPE L " + size);
    }

    public void structure(char structure) throws IOException {
        this.sendCommand("STRU " + structure);
    }

    public void transferMode(char mode) throws IOException {
        this.sendCommand("MODE " + mode);
    }

    public FtpReader retrieve(String path) throws IOException {
        InputStream istr = this.getRetrieveStream(path);
        if (istr == null) {
            return null;
        }
        InputStreamReader in = new InputStreamReader(istr);
        return new FtpReader(in, this);
    }

    public FtpInputStream retrieveStream(String path) throws IOException {
        InputStream istr = this.getRetrieveStream(path);
        if (istr == null) {
            return null;
        }
        return new FtpInputStream(istr, this);
    }

    protected InputStream getRetrieveStream(String path) throws IOException {
        this.sendCommand("RETR " + path);
        if (!this.getResponse().isPositivePreliminary()) {
            return null;
        }
        return this.getTransferSocket().getInputStream();
    }

    public FtpWriter store(String path) throws IOException {
        OutputStream ostr = this.getStoreStream(path);
        if (ostr == null) {
            return null;
        }
        OutputStreamWriter out = new OutputStreamWriter(ostr);
        return new FtpWriter(out, this);
    }

    public FtpOutputStream storeStream(String path) throws IOException {
        OutputStream ostr = this.getStoreStream(path);
        if (ostr == null) {
            return null;
        }
        return new FtpOutputStream(ostr, this);
    }

    protected OutputStream getStoreStream(String path) throws IOException {
        this.sendCommand("STOR " + path);
        if (!this.getResponse().isPositivePreliminary()) {
            return null;
        }
        return this.getTransferSocket().getOutputStream();
    }

    public FtpWriter storeUnique() throws IOException {
        OutputStream ostr = this.getStoreUniqueStream();
        if (ostr == null) {
            return null;
        }
        OutputStreamWriter out = new OutputStreamWriter(ostr);
        return new FtpWriter(out, this);
    }

    public FtpOutputStream storeUniqueStream() throws IOException {
        OutputStream ostr = this.getStoreUniqueStream();
        if (ostr == null) {
            return null;
        }
        return new FtpOutputStream(ostr, this);
    }

    protected OutputStream getStoreUniqueStream() throws IOException {
        this.sendCommand("STOU");
        if (!this.getResponse().isPositivePreliminary()) {
            return null;
        }
        return this.getTransferSocket().getOutputStream();
    }

    public FtpWriter append(String path) throws IOException {
        OutputStream ostr = this.getAppendStream(path);
        if (ostr == null) {
            return null;
        }
        OutputStreamWriter out = new OutputStreamWriter(ostr);
        return new FtpWriter(out, this);
    }

    public FtpOutputStream appendStream(String path) throws IOException {
        OutputStream ostr = this.getAppendStream(path);
        if (ostr == null) {
            return null;
        }
        return new FtpOutputStream(ostr, this);
    }

    protected OutputStream getAppendStream(String path) throws IOException {
        this.sendCommand("APPE " + path);
        if (!this.getResponse().isPositivePreliminary()) {
            return null;
        }
        return this.getTransferSocket().getOutputStream();
    }

    public void allocate(int size, int recSize) throws IOException {
        this.sendCommand("ALLO " + size + " R " + recSize);
    }

    public void allocate(int size) throws IOException {
        this.sendCommand("ALLO " + size);
    }

    public void restart(String marker) throws IOException {
        this.sendCommand("REST " + marker);
    }

    public void renameFrom(String path) throws IOException {
        this.sendCommand("RNFR " + path);
    }

    public void renameTo(String path) throws IOException {
        this.sendCommand("RNTO " + path);
    }

    public void abort() throws IOException {
        this.sendCommand("ABOR");
    }

    public void delete(String path) throws IOException {
        this.sendCommand("DELE " + path);
    }

    public void removeDirectory(String path) throws IOException {
        this.sendCommand("RMD " + path);
    }

    public void makeDirectory(String path) throws IOException {
        this.sendCommand("MKD " + path);
    }

    public void printWorkingDirectory() throws IOException {
        this.sendCommand("PWD");
    }

    public FtpReader list(String path) throws IOException {
        InputStream istr = this.getListStream(path);
        if (istr == null) {
            return null;
        }
        InputStreamReader in = new InputStreamReader(istr);
        return new FtpReader(in, this);
    }

    public FtpReader list() throws IOException {
        return this.list(null);
    }

    public FtpInputStream listStream(String path) throws IOException {
        InputStream istr = this.getListStream(path);
        if (istr == null) {
            return null;
        }
        return new FtpInputStream(istr, this);
    }

    public FtpInputStream listStream() throws IOException {
        return this.listStream(null);
    }

    protected InputStream getListStream(String path) throws IOException {
        if (path == null) {
            this.sendCommand("LIST");
        } else {
            this.sendCommand("LIST " + path);
        }
        if (!this.getResponse().isPositivePreliminary()) {
            return null;
        }
        return this.getTransferSocket().getInputStream();
    }

    public FtpReader nameList(String path) throws IOException {
        InputStream istr = this.getNameListStream(path);
        if (istr == null) {
            return null;
        }
        InputStreamReader in = new InputStreamReader(istr);
        return new FtpReader(in, this);
    }

    public FtpReader nameList() throws IOException {
        return this.nameList(null);
    }

    public FtpInputStream nameListStream(String path) throws IOException {
        InputStream istr = this.getNameListStream(path);
        if (istr == null) {
            return null;
        }
        return new FtpInputStream(istr, this);
    }

    public FtpInputStream nameListStream() throws IOException {
        return this.nameListStream(null);
    }

    protected InputStream getNameListStream(String path) throws IOException {
        if (path == null) {
            this.sendCommand("NLIST");
        } else {
            this.sendCommand("NLST " + path);
        }
        if (!this.getResponse().isPositivePreliminary()) {
            return null;
        }
        return this.getTransferSocket().getInputStream();
    }

    public void siteParameters(String param) throws IOException {
        this.sendCommand("SITE " + param);
    }

    public void system() throws IOException {
        this.sendCommand("SYST");
    }

    public void status(String path) throws IOException {
        if (path == null) {
            this.sendCommand("STAT");
        } else {
            this.sendCommand("STAT " + path);
        }
    }

    public void status() throws IOException {
        this.status(null);
    }

    public void help(String arg) throws IOException {
        if (arg == null) {
            this.sendCommand("HELP");
        } else {
            this.sendCommand("HELP " + arg);
        }
    }

    public void help() throws IOException {
        this.help(null);
    }

    public void noOp() throws IOException {
        this.sendCommand("NOOP");
    }

    protected void setResponse() throws IOException {
        this.response = new FtpResponse(this.in);
        this.responseArchive.addElement(this.response);
        this.debug("received response", this.response);
    }

    protected void closeTransferSocket() throws IOException {
        if (this.dataXfrSocket != null) {
            this.dataXfrSocket.close();
            this.dataXfrSocket = null;
            this.setResponse();
        }
    }

    private void debug(Object heading, Object message) {
        Log.log((int)1, (Object)this, (Object)(Thread.currentThread() + ": " + heading + ": " + message));
    }

    private Socket getTransferSocket() throws IOException {
        if (this.dataXfrSocket != null) {
            this.dataXfrSocket.close();
            this.dataXfrSocket = null;
        }
        if (this.passiveSocket != null) {
            this.dataXfrSocket = this.passiveSocket;
        } else if (this.dataSocket != null) {
            this.dataXfrSocket = this.dataSocket.accept();
            this.dataXfrSocket.setSoTimeout(45000);
        }
        return this.dataXfrSocket;
    }
}

